% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpp_proc.R
\name{mpp_proc}
\alias{mpp_proc}
\title{MPP QTL analysis}
\usage{
mpp_proc(pop.name = "MPP", trait.name = "trait1", mppData, trait = 1,
  Q.eff = "cr", plot.gen.eff = FALSE, thre.cof = 3, win.cof = 50,
  N.cim = 1, window = 20, thre.QTL = 3, win.QTL = 20, backward = TRUE,
  alpha.bk = 0.05, ref.par = NULL, sum_zero = FALSE, CI = FALSE,
  drop = 1.5, text.size = 18, n.cores = 1, verbose = TRUE, output.loc)
}
\arguments{
\item{pop.name}{\code{Character} name of the studied population.
Default = "MPP".}

\item{trait.name}{\code{Character} name of the studied trait.
Default = "trait1".}

\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Numerical} or \code{character} indicator to specify which
trait of the \code{mppData} object should be used. Default = 1.}

\item{Q.eff}{\code{Character} expression indicating the assumption concerning
the QTL effect: 1) "cr" for cross-specific effects; 2) "par" parental
effects; 3) "anc" for an ancestral effects; 4) "biall" for a bi-allelic
effects. For more details see \code{\link{mpp_SIM}}. Default = "cr".}

\item{plot.gen.eff}{\code{Logical} value. If \code{plot.gen.eff = TRUE},
the function will save the decomposed genetic effects per cross/parent.
These results can be plotted with the function \code{\link{plot.QTLprof}}
to visualize a genome-wide decomposition of the genetic effects.
\strong{This functionality is ony available for the cross-specific,
parental and ancestral models.}
Default value = FALSE.}

\item{thre.cof}{\code{Numeric} value representing the -log10(p-value)
threshold above which a position can be peaked as a cofactor. Default = 3.}

\item{win.cof}{\code{Numeric} value in centi-Morgan representing the minimum
distance between two selected cofactors. Default = 50.}

\item{N.cim}{\code{Numeric} value specifying the number of time the CIM
analysis is repeated. Default = 1.}

\item{window}{\code{Numeric} distance (cM) on the left and the right of a
cofactor position where it is not included in the model. Default = 20.}

\item{thre.QTL}{\code{Numeric} value representing the -log10(p-value)
threshold above which a position can be selected as QTL. Default = 3.}

\item{win.QTL}{\code{Numeric} value in centi-Morgan representing the minimum
distance between two selected QTLs. Default = 20.}

\item{backward}{\code{Logical} value. If \code{backward = TRUE},
the function performs a backward elimination on the list of selected QTLs.
Default = TRUE.}

\item{alpha.bk}{\code{Numeric} value indicating the significance level for
the backward elimination. Terms with p-values above this value will
iteratively be removed. Default = 0.05.}

\item{ref.par}{Optional \code{Character} expression defining the parental
allele that will be used as reference to compute QTL effects for the parental
model. For the ancestral model, the ancestral class containing the reference
parent will be set as reference. \strong{This option can only be used if
the MPP design is composed of a unique connected part}. Default = NULL.}

\item{sum_zero}{Optional \code{Logical} value specifying if the QTL effect of
a parental or an ancestral model should be calculated using the sum to zero
constraint. Default = FALSE.}

\item{CI}{\code{Logical} value. If \code{CI = TRUE}, the function will
compute a -log10(pval) drop confidence interval for each QTL after
calculating a CIM- profile (without cofactors on the scanned chromosome).
Default = FALSE.}

\item{drop}{\code{Numeric} -log10(p-value) drop value at the limits of the
interval. Default = 1.5.}

\item{text.size}{\code{Numeric} value specifying the size of graph axis text
elements. Default = 18.}

\item{n.cores}{\code{Numeric}. Specify here the number of cores you like to
use. Default = 1.}

\item{verbose}{\code{Logical} value indicating if the steps of mpp_proc should
be printed. Default = TRUE.}

\item{output.loc}{Path where a folder will be created to save the results.}
}
\value{
Return:

List containing the following items:

\item{n.QTL}{Number of detected QTLs.}

\item{cofactors}{\code{Data.frame} with cofactors positions.}

\item{QTL}{\code{Data.frame} with QTL positions.}

\item{R2}{\code{List} containing R squared statistics of the QTL effects.
For details see \code{\link{QTL_R2}} output section.}

\item{QTL.effects}{\code{List} of QTLs genetic effects. For details see
\code{\link{QTL_gen_effects}} output section.}

\item{QTL.CI}{If \code{CI = TRUE}, confidence interval information of
the QTLs.}

Some output files are also saved at the specified location
(\code{output.loc}):

\enumerate{

\item{A QTL report (QTL_REPORT.txt) with: 1) the number of detected QTLs;
2) the global R squared statistics; 3) for each QTL, position information
(plus confidence interval if \code{CI = TRUE}) and estimated QTL genetic
effects per cross or parents (for details see \code{\link{QTL_gen_effects}}).}

\item{The SIM and CIM results in a text file (SIM.txt, CIM.txt).}

\item{The list of cofactors (cofactors.txt).}

\item{The list of QTL (QTL.txt).}

\item{The QTL R squared statistics (QTL_R2.txt) (for details see
\code{\link{QTL_R2}}).}

\item{If \code{CI = TRUE}, the QTL confidence intervals (QTL_CI.txt).}

\item{General results of the QTL detection process: number of QTLs and
global adjusted and non-adjusted R squared statistics (QTL_genResults.txt).}

\item{The plot of the CIM profile (QTL_profile.pdf) with dotted vertical
lines representing the cofactors positions. If \code{plot.gen.eff = TRUE},
plot of the genetic effects per cross or parents (gen_eff.pdf) with dashed
lines representing the QTL positions. For more details see
\code{\link{plot.QTLprof}}}

}
}
\description{
Multi-parent population QTL analysis.
}
\details{
The function run a full MPP QTL detection using models with different possible
assumptions concerning the number of alleles at the QTL position. For more
details about the different models, see documentation of the function
\code{\link{mpp_SIM}}. The procedure is the following:

\enumerate{

\item{Simple interval mapping (SIM) to select cofactor
(\code{\link{mpp_SIM}}).}

\item{Composite interval mapping (CIM) with selected cofactors
(\code{\link{mpp_CIM}}).}

\item{Optional backward elimination on the list of QTL
candidates (\code{backward = TRUE}) (\code{\link{mpp_back_elim}}).}

\item{Computation of the QTL genetic effects (\code{\link{QTL_gen_effects}})
and proportion of the phenotypic variation explained by the QTLs (R squared)
(\code{\link{QTL_R2}}).}

\item{Optional QTL confidence interval computation from a CIM- profile
(excluding cofactors on the scanned chromosome) (\code{argument CI=TRUE}).}

}
}
\examples{
 

data(mppData)

# Specify a location where your results will be saved
my.loc <- tempdir()

# Cross-specific model

USNAM_cr <- mpp_proc(pop.name = "USNAM", trait.name = "ULA",
                     mppData = mppData, plot.gen.eff = TRUE, CI = TRUE,
                     verbose = FALSE, output.loc = my.loc)




}
\seealso{
\code{\link{mpp_back_elim}},
\code{\link{mpp_CIM}},
\code{\link{mpp_perm}},
\code{\link{mpp_SIM}},
\code{\link{plot.QTLprof}},
\code{\link{QTL_gen_effects}},
\code{\link{QTL_R2}}
}
\author{
Vincent Garin
}
