% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linking.R
\name{link_gaps}
\alias{link_gaps}
\title{Link gaps to (ESM) data}
\usage{
link_gaps(
  data,
  gaps,
  by = NULL,
  offset_before = 0,
  offset_after = 0,
  raw_data = FALSE
)
}
\arguments{
\item{data}{A data frame or an extension to a data frame (e.g. a tibble). While gap data can be
linked to any other type of data, ESM data is most commonly used.}

\item{gaps}{A data frame (extension) containing the gap data. See \code{\link[=identify_gaps]{identify_gaps()}} for
retrieving gap data from an mpathsenser database. It should at least contain the columns \code{from}
and \code{to} (both in a date-time format), as well as any specified columns in \code{by}.}

\item{by}{A character vector indicating the variable(s) to match by, typically the participant
IDs. If NULL, the default, \verb{*_join()} will perform a natural join, using all variables in
common across \code{x} and \code{y}. Therefore, all data will be mapped to each other based on the time
stamps of \code{x} and \code{y}. A message lists the variables so that you can check they're correct;
suppress the message by supplying by explicitly.

To join by different variables on \code{x} and \code{y}, use a named vector. For example, \code{by = c('a' = 'b')} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a vector with \code{length > 1}. For example, \code{by = c('a', 'b')}
will match \code{x$a} to \code{y$a} and \code{x$b} to \code{y$b}. Use a named vector to match different variables
in \code{x} and \code{y}. For example, \code{by = c('a' = 'b', 'c' = 'd')} will match \code{x$a} to \code{y$b} and \code{x$c}
to \code{y$d}.

To perform a cross-join (when \code{x} and \code{y} have no variables in common), use \code{by = character()}.
Note that the \code{split} argument will then be set to 1.}

\item{offset_before}{The time before each measurement in \code{x} that denotes the period in which \code{y}
is matched. Must be convertible to a period by \code{\link[lubridate:as.period]{lubridate::as.period()}}.}

\item{offset_after}{The time after each measurement in \code{x} that denotes the period in which \code{y}
is matched. Must be convertible to a period by \code{\link[lubridate:as.period]{lubridate::as.period()}}.}

\item{raw_data}{Whether to include the raw data (i.e. the matched gap data) to the output as
gap_data.}
}
\value{
The original \code{data} with an extra column \code{duration} indicating the gap during within the
interval in seconds (if \code{duration}  is \code{TRUE}), or an extra column called \code{gap_data} containing
the gaps within the interval. The function ensures all durations and gap time stamps are within
the range of the interval.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Gaps in mobile sensing data typically occur when the app is stopped by the operating system or
the user. While small gaps may not pose problems with analyses, greater gaps may cause bias or
skew your data. As a result, gap data should be considered in order to inspect and limit their
influence. This function, analogous to \code{\link[=link]{link()}}, allows you to connect gaps to other data
(usually ESM/EMA data) within a user-specified time range.
}
\examples{
# Create some data
x <- data.frame(
  time = rep(seq.POSIXt(as.POSIXct("2021-11-14 13:00:00"), by = "1 hour", length.out = 3), 2),
  participant_id = c(rep("12345", 3), rep("23456", 3)),
  item_one = rep(c(40, 50, 60), 2)
)

# Create some gaps
gaps <- data.frame(
 from = as.POSIXct(c("2021-11-14 13:00:00", "2021-11-14 14:00:00")),
 to = as.POSIXct(c("2021-11-14 13:30:00", "2021-11-14 14:30:00")),
 participant_id = c("12345", "23456")
)

# Link the gaps to the data
link_gaps(x, gaps, by = "participant_id", offset_before = 0, offset_after = 1800)

# Link the gaps to the data and include the raw data
link_gaps(
  x,
  gaps,
  by = "participant_id",
  offset_before = 0,
  offset_after = 1800,
  raw_data = TRUE
)
}
\seealso{
\code{\link[=bin_data]{bin_data()}} for linking two sets of intervals to each other; \code{\link[=identify_gaps]{identify_gaps()}} for
finding gaps in the sampling; \code{\link[=add_gaps]{add_gaps()}} for adding gaps to sensor data;
}
