% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputationGenerics.R
\name{imputationKey}
\alias{imputationKey}
\alias{imputationKey,imputed-method}
\alias{imputationKey,geneticData-method}
\alias{imputationKey,mpcrossMapped-method}
\title{Get out key for IBD genotype imputations}
\usage{
imputationKey(object, ...)

\S4method{imputationKey}{imputed}(object, ...)

\S4method{imputationKey}{geneticData}(object, ...)

\S4method{imputationKey}{mpcrossMapped}(object, ...)
}
\arguments{
\item{object}{The object from which to get the imputation key.}

\item{...}{Extra parameters. Currently only \code{"experiment"} is supported, letting the user extract the imputation map for a specific experiment.}
}
\value{
Key giving the encoding of heterozygotes, in the imputed IBD genotype data.
}
\description{
Get out key for IBD genotype imputations
}
\details{
When IBD genotype imputation is performed using a population with finite generations of selfing, some of the imputed genotypes will be heterozygotes. However, the imputation code only returns a single value per line per genetic position. This key translates that value to a pair of founder alleles. 

The key is a matrix with three columns. The first two columns represent founder alleles, and the third column gives the encoding for that particular pair of founder alleles.
}
\examples{
pedigree <- eightParentPedigreeRandomFunnels(initialPopulationSize = 100, 
	selfingGenerations = 2, nSeeds = 1, intercrossingGenerations = 0)
selfing(pedigree) <- "finite"
#Generate map
map <- qtl::sim.map()
#Simulate data
cross <- simulateMPCross(map = map, pedigree = pedigree, mapFunction = haldane)
crossSNP <- cross + multiparentSNP(keepHets = TRUE)
crossMapped <- mpcrossMapped(crossSNP, map = map)
imputed <- imputeFounders(crossMapped, errorProb = 0.01)
#An imputed IBD genotype of 1 indicates a homozygote for founder 1
#An imputed IBD genotype of 9 indicates a heterozygote for founders 1 and 2
#etc
head(imputationKey(imputed))
}
