#' Climate studies example dataset
#'
#' Data extracted from ERA5 hourly data on single levels from 1940 to present
#'
#' \describe{
#'   \item{Year}{8 years from 1950 to 2020}
#'   \item{Month}{12 calendar months}
#'   \item{Region}{10 IPCC climate reference regions}
#'   \item{AccPrec}{Accumulated precipitation}
#'   \item{DailyEva}{Daily evaporation}
#'   \item{Temp}{Mean temperature}
#'   \item{SoilMois}{Soil moisture}
#'   \item{SPI6}{6-month standardised precipitation index}
#'   \item{wind}{Windspeed}
#' }
#'
#' @name Africa_climate
#' @docType data
#' @format A dataset with 960 observations and 9 variables.
#' @keywords datasets
#' @source DOI: 10.24381/cds.adbb2d47 (Accessed on 11-02-2025)
NULL

#' Climate studies target example dataset
#'
#' Data extracted from ERA5 hourly data on single levels for 1989
#'
#' \describe{
#'   \item{Year}{8 years from 1950 to 2020}
#'   \item{Month}{12 calendar months}
#'   \item{Region}{10 IPCC climate reference regions}
#'   \item{AccPrec}{Accumulated precipitation}
#'   \item{DailyEva}{Daily evaporation}
#'   \item{Temp}{Mean temperature}
#'   \item{SoilMois}{Soil moisture}
#'   \item{SPI6}{6-month standardised precipitation index}
#'   \item{wind}{Windspeed}
#' }
#'
#' @name Africa_climate_target
#' @docType data
#' @format A dataset with 120 observations and 9 variables.
#' @keywords datasets
#' @source DOI: 10.24381/cds.adbb2d47 (Accessed on 11-02-2025)
NULL

#' @rdname Africa_climate
