% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_distance.R
\name{mt_distance}
\alias{mt_distance}
\alias{mt_speed}
\title{Return distances or speeds between locations}
\usage{
mt_distance(x)

mt_speed(x)
}
\arguments{
\item{x}{a \code{move2} object. Timestamps must be ordered within tracks and only contain location data (See 'Details').}
}
\value{
a vector of the same length as the \code{move2} object containing the distances/speeds between locations.
Each element is the distance/speed to the next location.
The last value for each track will be \code{NA}. Units are included when the data have a coordinate reference system set.
}
\description{
The distance or speed is calculated between consecutive locations
}
\details{
\code{mt_is_time_ordered_non_empty_points} can be used to check if the timestamps are ordered and if the object only
contains location data.  To omit empty locations use e.g. \code{dplyr::filter(x,!sf::st_is_empty(x))}.

Distances are calculated using \link[sf:geos_measures]{sf::st_distance}.
}
\examples{
## distance between consecutive locations
mt_sim_brownian_motion() |>
  mt_distance() |>
  head()
## When the data has a coordinate reference system set,
## units are included
dist <- mt_sim_brownian_motion(1:4) |>
  sf::st_set_crs(4326L) |>
  mt_distance()
dist
## transform units of output
units::set_units(dist, km)

## speed between consecutive locations
mt_sim_brownian_motion() |> mt_speed()
## When projections are provided units are included
speed_calc <- mt_read(mt_example())[330:340, ] |>
  mt_speed()
speed_calc
## transform units of output
units::set_units(speed_calc, m/s)

mt_read(mt_example())[330:340, ] |>
  sf::st_transform("+proj=aeqd +units=km +lon_0=-73.9 +lat_0=42.7") |>
  mt_speed()

}
\seealso{
Other track-measures: 
\code{\link{mt_azimuth}()},
\code{\link{mt_time}()}
}
\concept{track-measures}
