% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{mt_plot_add_rect}
\alias{mt_plot_add_rect}
\title{Add rectangles to trajectory plot.}
\usage{
mt_plot_add_rect(rect, color = "black", fill = NA, ...)
}
\arguments{
\item{rect}{a data.frame or matrix with one row per box. For each rectangle,
the x-position (\code{x}), y-position (\code{y}), width (\code{w}), and
height (\code{h}) needs to be provided. If columns are not labeled, the
order \code{x, y, w, h} is assumed.}

\item{color}{argument passed on to \link[ggplot2:geom_tile]{geom_rect}. Specifies the
color of the border of the rectangles.}

\item{fill}{argument passed on to \link[ggplot2:geom_tile]{geom_rect}. Specifies the
color of the interior of the rectangles. If \code{NA} (the default),
rectangles are unfilled.}

\item{...}{additional arguments passed on to \link[ggplot2:geom_tile]{geom_rect}.}
}
\description{
\code{mt_plot_add_rect} adds one or several rectangles to a mousetrap plot.
These buttons usually correspond to the borders of the buttons in the
mouse-tracking experiment. It is specifically designed so that the arguments
from the \code{mousetrap_response} plugin in OpenSesame can be used.
}
\details{
\code{mt_plot_add_rect} internally uses \link[ggplot2:geom_tile]{geom_rect} of the
\code{ggplot2} package for plotting.
}
\examples{
# Load ggplot2
library(ggplot2)

# Import, flip, and time-normalize raw trajectories
mt_example <- mt_import_mousetrap(mt_example_raw)
mt_example <- mt_remap_symmetric(mt_example,remap_xpos="no")
mt_example <- mt_time_normalize(mt_example)

# Create rectangles matrix
rectangles <- matrix(
  # (The matrix is n x 4, and contains
  # all relevant data for every button,
  # (i.e. x, y, width and height values)
  # in separate rows)
  c(
   -840, 525,  350, -170,
    840, 525, -350, -170
  ),
  ncol=4, byrow=TRUE)

# Plot all time-normalized trajectories
# varying the color depending on the condition
# and add rectangles
mt_plot(mt_example,
  use="trajectories",
  x="xpos", y="ypos", color="Condition"
) + mt_plot_add_rect(rect=rectangles)


}
\seealso{
\link{mt_plot} for plotting trajectory data.
}
\author{
Pascal J. Kieslich

Felix Henninger
}
