% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral.R
\name{build_laplacian}
\alias{build_laplacian}
\title{Build a Laplacian matrix}
\usage{
build_laplacian(adj_mat, type_lap = c("comb", "rw"))
}
\arguments{
\item{adj_mat}{Symmetric adjacency matrix from which to build the Laplacian.}

\item{type_lap}{Type of Laplacian to build.
One of \code{"comb"} (combinatorial) or \code{"rw"} (random-walk).}
}
\value{
The specified Laplacian matrix.
}
\description{
Build a Laplacian matrix (combinatorial Laplacian or random-walk Laplacian)
from a symmetric (weighted) graph adjacency matrix.
}
\examples{
adj_mat <- matrix(c(1:9), nrow = 3)
build_laplacian(adj_mat, "rw")
}
