% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{relm}
\alias{relm}
\title{Resample a Linear Model}
\usage{
relm(model, ..., envir = environment(formula(model)))
}
\arguments{
\item{model}{a linear model object produced using \code{\link[=lm]{lm()}}.}

\item{...}{additional arguments passed through to \code{\link[=resample]{resample()}}.}

\item{envir}{an environment in which to (re)evaluate the linear model.}
}
\description{
Fit a new model to data created using \code{resample(model)}.
}
\examples{
mod <- lm(length ~ width, data = KidsFeet)
do(1) * mod 
do(3) * relm(mod) 
# use residual resampling to estimate standard error (very crude because so few replications)
Boot <- do(100) * relm(mod)
sd(~ width, data = Boot)
# standard error as produced by summary() for comparison
mod |> summary() |> coef() 

}
\seealso{
\code{resample()}
}
