% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregatingMeta.R
\name{aggregatingFunction1or2}
\alias{aggregatingFunction1or2}
\title{1- or 2-ary aggregating functions}
\usage{
aggregatingFunction1or2(fun, output.multiple = FALSE,
  na.rm = getOption("na.rm", FALSE))
}
\arguments{
\item{fun}{a function that takes 1 or 2 numeric vectors and computes a summary statistic,
returning a numeric vector of length 1.}

\item{output.multiple}{a boolean indicating whether \code{fun} returns multiple values}

\item{na.rm}{the default value for na.rm in the resulting function.}
}
\description{
\code{aggregatingFunction1or2()} creates statistical summaries for functions like
\code{\link[=var]{var()}} that can have either 1 or 2 numeric vector inputs.
}
\details{
This was designed primarily to support \code{var} which can be used to compute
either the variance of one variable or the covariance of two variables.
The logic of the resulting function is this: 1) If the first two arguments are both formulas,
then those formulas are evaluated (with \code{data}) to compute the covariance;
(2) If the first argument is a formula, and the second is \code{NULL},
then the formula and \code{data} are used to create the necessary call(s) to \code{fun};
(3) Else everything is simply passed to \code{fun} for evaluation.
}
\section{Note}{

Earlier versions of this function supported a "bare name + data frame" interface.  This
functionality has been removed since it was (a) ambiguous in some cases, (b) unnecessary,
and (c) difficult to maintain.
}

