% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupwiseModels.R
\name{predict.groupwiseModel}
\alias{predict.groupwiseModel}
\title{Evaluate a groupwise model given new data}
\usage{
\method{predict}{groupwiseModel}(object, newdata = object$data,
  type = c("class", "likelihood", "prob"), level = NULL, ...)
}
\arguments{
\item{object}{a groupwise model}

\item{newdata}{new data from which to compute fitted valeus.}

\item{type}{one of "class", "likelihood", or "prob"}

\item{level}{an optional character string specifying the level for which probabilities are to be reported. Defaults
to the first class of the potential outputs. Set to \code{".all"} to see probabilities for all levels.}

\item{...}{additional arguments (currently ignored)}
}
\description{
If \code{newdata} is not specified, the data originally used for fitting will be used.
}
\details{
setting the \code{type} is needed only for classifiers. \code{"class"} will give just the 
class as output. \code{"likelihood"} will give the probability of the observed outcome (in \code{newdata}) 
given the model. \code{"prob"} will give the probability of the class named in \code{level}
}

