% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproFitTT.R
\name{reproFitTT}
\alias{reproFitTT}
\title{Fits a Bayesian concentration-effect model for target-time reproduction analysis}
\usage{
reproFitTT(data, stoc.part = "bestfit", target.time = NULL, ecx = c(5, 10,
  20, 50), n.chains = 3, quiet = FALSE)
}
\arguments{
\item{data}{an object of class \code{reproData}}

\item{stoc.part}{stochastic part of the model. Possible values are \code{"bestfit"},
\code{"poisson"} and \code{"gammapoisson"}}

\item{target.time}{defines the target time point at which to analyse the repro data. By default the last time point}

\item{ecx}{desired values of \eqn{x} (in percent) for which to compute
\eqn{EC_{x}}{ECx}}

\item{n.chains}{number of MCMC chains. The minimum required number of chains is 2}

\item{quiet}{if \code{TRUE}, does not print messages and progress bars from JAGS}
}
\value{
The function returns an object of class \code{reproFitTT} which is a list
of the following objects:
\item{DIC}{DIC value of the selected model}
\item{estim.ECx}{a table of the estimated 5, 10, 20 and 50 \% effective
concentrations (by default) and their 95 \% credible intervals}
\item{estim.par}{a table of the estimated parameters as medians and 95 \%
credible intervals}
\item{mcmc}{an object of class \code{mcmc.list} with the posterior distribution}
\item{model}{a JAGS model object}
\item{warnings}{a data.frame with warning messages}
\item{model.label}{a character string, \code{"P"} if the Poisson model is used,
\code{"GP"} if the gamma-Poisson is used}
\item{parameters}{a list of the parameter names used in the model}
\item{n.chains}{an integer value corresponding to the number of chains used
for the MCMC computation}
\item{n.iter}{a list of two indices indicating the beginning and
the end of monitored iterations}
\item{n.thin}{a numerical value corresponding to the thinning interval}
\item{jags.data}{a list of the data passed to the jags model}
\item{transformed.data}{the \code{survData} object passed to the function}
\item{dataTT}{the dataset with which the parameters are estimated}
}
\description{
This function estimates the parameters of a concentration-effect model for
target-time reproduction analysis using Bayesian inference.
In this model the endpoint is the cumulated number of reproduction outputs over
time, with potential mortality all along the experiment.
}
\details{
Because some individuals may die during the observation period, the
reproduction rate alone is not sufficient to account for the observed number
of offspring at a given time point. In addition, we need the time individuals have stayed alive
during this observation period. The \code{reproFitTT} function estimates the number
of individual-days in an experiment between its start and the target time.
This covariable is then used to estimate a relation between the chemical compound
concentration and the reproduction rate \emph{per individual-day}.

The \code{reproFitTT} function fits two models, one where inter-individual
variability is neglected ("Poisson" model) and one where it is taken into
account ("gamma-Poisson" model). When setting \code{stoc.part} to
\code{"bestfit"}, a model comparison procedure is used to choose between
both. More details are presented in the vignette accompanying the package.
}
\examples{

# (1) Load the data
data(cadmium1)

# (2) Create an object of class "reproData"
dataset <- reproData(cadmium1)

\dontrun{
# (3) Run the reproFitTT function with the log-logistic gamma-Poisson model
out <- reproFitTT(dataset, stoc.part = "gammapoisson",
                  ecx = c(5, 10, 15, 20, 30, 50, 80), quiet = TRUE)
}

}
\keyword{estimation}
