% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_id.R
\name{add_group}
\alias{add_group}
\title{Add group id column into result of morphological analysis}
\usage{
add_group(
  tbl,
  col,
  brk = "EOS",
  grp = "group",
  cond = NULL,
  end_with_brk = TRUE
)
}
\arguments{
\item{tbl}{A dataframe}

\item{col}{A string to specify the column including breaks}

\item{brk}{A string to specify breaks}

\item{grp}{A string to specify group}

\item{cond}{A string to specify condition}

\item{end_with_brk}{A logical}
}
\value{
A dataframe
}
\description{
Add group id column into result of morphological analysis
}
\examples{
brk <- "EOS"
tbl <- tibble::tibble(col=c(rep("a", 2), brk, rep("b", 3), brk, rep("c", 4), brk))
add_group(tbl, col = "col")
add_group(tbl, col = "col", end_with_brk = FALSE)

}
