% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_group.R
\name{make_groups}
\alias{make_groups}
\alias{make_groups_sub}
\alias{max_sum_str_length}
\title{Make groups by splitting string length}
\usage{
make_groups(tbl, text_col = "text", length = 8000)

make_groups_sub(tbl, text_col, n_group)

max_sum_str_length(tbl)
}
\arguments{
\item{tbl}{A tibble or data.frame.}

\item{text_col}{A text. Colnames for morphological analysis.}

\item{length}{A numeric.}

\item{n_group}{A numeric.}
}
\value{
A tibble.   Output of 'MeCab' and added column "text_id".
}
\description{
Using 'MeCab' for morphological analysis.
Keep other colnames in dataframe.
}
\examples{
\dontrun{
  library(tidyverse)
  data(neko)
  neko <-
      neko \%>\%
      dplyr::mutate(text=stringi::stri_unescape_unicode(text)) \%>\%
      dplyr::mutate(cols=1:nrow(.))
  moranajp_all(neko, text_col = "text") \%>\%
      print(n=100)
}
}
