test_that("generate_xml", {
  file <- system.file("extdata", "questions.csv", package = "moodef")
  qc <-
    question_category(category = 'Initial test', adapt_images = TRUE) |>
    define_questions_from_csv(file = file)

  xml <- qc |>
    generate_xml()

  qc2 <- qc |>
    generate_xml_file(file = tempfile(fileext = '.xml'))

  file <-
    system.file("extdata", "questions_image.csv", package = "moodef")
  df <- read_question_csv(file = file)
  df[1, 'image'] <-
    system.file("extdata", "divide.png", package = "moodef")
  df[2, 'image'] <-
    system.file("extdata", "ops.png", package = "moodef")
  qc3 <-
    question_category(category = 'Initial test', adapt_images = TRUE) |>
    define_questions_from_data_frame(df)
  xml3 <- qc3 |>
    generate_xml()

  expect_equal(qc, qc2)

  expect_equal(
    xml,
    structure(
      "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<quiz>\n  <question type=\"category\">\n    <category> <text>$course$/top/Initial test</text> </category>\n    <info format=\"html\"> <text></text> </info>\n    <idnumber></idnumber>\n  </question>\n  <question type=\"multichoice\">\n<name> <text>q_001_multichoice_what_are_the_basic_arithmetic_operations</text> </name>\n<questiontext format=\"html\">\n  <text><![CDATA[\n     <!--  -->\n     <!--  -->\n     <p>What are the basic arithmetic operations?</p>]]></text>\n     \n</questiontext>\n<generalfeedback format=\"html\"> <text></text> </generalfeedback>\n<defaultgrade>1.0000000</defaultgrade>\n<penalty>0.5</penalty>\n<hidden>0</hidden>\n<idnumber></idnumber>\n<single>true</single>\n<shuffleanswers>true</shuffleanswers>\n<answernumbering>abc</answernumbering>\n<showstandardinstruction>0</showstandardinstruction>\n<correctfeedback format=\"moodle_auto_format\"> <text>Correct.</text> </correctfeedback>\n<partiallycorrectfeedback format=\"moodle_auto_format\"> <text></text> </partiallycorrectfeedback>\n<incorrectfeedback format=\"moodle_auto_format\"> <text>Incorrect.</text> </incorrectfeedback>\n<answer fraction=\"100\" format=\"html\">\n   <text>Addition, subtraction, multiplication and division.</text>\n   <feedback format=\"html\"> <text>Correct.</text> </feedback>\n</answer>\n<answer fraction=\"-50.000000000000000\" format=\"html\">\n   <text>Addition and subtraction.</text>\n   <feedback format=\"html\"> <text>Incorrect.</text> </feedback>\n</answer>\n<answer fraction=\"-50.000000000000000\" format=\"html\">\n   <text>Addition, subtraction, multiplication, division and square root.</text>\n   <feedback format=\"html\"> <text>Incorrect.</text> </feedback>\n</answer>\n</question>\n<question type=\"matching\">\n<name> <text>q_002_matching_match_each_operation_with_its_symbol</text> </name>\n<questiontext format=\"html\">\n  <text><![CDATA[\n     <!--  -->\n     <!--  -->\n     <p>Match each operation with its symbol.</p>]]></text>\n     \n</questiontext>\n<generalfeedback format=\"html\"> <text></text> </generalfeedback>\n<defaultgrade>1.0000000</defaultgrade>\n<penalty>0.3333333</penalty>\n<hidden>0</hidden>\n<idnumber></idnumber>\n<shuffleanswers>true</shuffleanswers>\n<correctfeedback format=\"html\">\n  <text>Correct.</text>\n</correctfeedback>\n<partiallycorrectfeedback format=\"html\">\n  <text>Partially correct.</text>\n</partiallycorrectfeedback>\n<incorrectfeedback format=\"html\">\n  <text>Incorrect.</text>\n</incorrectfeedback>\n<shownumcorrect/>\n<subquestion format=\"html\">\n  <text><![CDATA[<p>Addition<br></p>]]></text>\n  <answer>\n    <text>+</text>\n  </answer>\n</subquestion>\n<subquestion format=\"html\">\n  <text><![CDATA[<p>Subtraction<br></p>]]></text>\n  <answer>\n    <text>-</text>\n  </answer>\n</subquestion>\n<subquestion format=\"html\">\n  <text><![CDATA[<p>Multiplication<br></p>]]></text>\n  <answer>\n    <text>*</text>\n  </answer>\n</subquestion>\n</question>\n<question type=\"truefalse\">\n<name> <text>q_003_truefalse_the_square_root_is_a_basic_arithmetic_op</text> </name>\n<questiontext format=\"html\">\n  <text><![CDATA[\n     <!--  -->\n     <!--  -->\n     <p>The square root is a basic arithmetic operation.</p>]]></text>\n     \n</questiontext>\n<generalfeedback format=\"html\"> <text></text> </generalfeedback>\n<defaultgrade>1.0000000</defaultgrade>\n<penalty>1.0000000</penalty>\n<hidden>0</hidden>\n<idnumber></idnumber>\n<answer fraction=\"100\" format=\"moodle_auto_format\">\n  <text>false</text>\n  <feedback format=\"html\">\n    <text></text>\n  </feedback>\n</answer>\n<answer fraction=\"0\" format=\"moodle_auto_format\">\n  <text>true</text>\n  <feedback format=\"html\">\n    <text></text>\n  </feedback>\n</answer>\n</question>\n<question type=\"shortanswer\">\n<name> <text>q_004_shortanswer_what_basic_operation_does_it_have_as_a</text> </name>\n<questiontext format=\"html\">\n  <text><![CDATA[\n     <!--  -->\n     <!--  -->\n     <p>What basic operation does it have as a \"+\" symbol?</p>]]></text>\n     \n</questiontext>\n<generalfeedback format=\"html\"> <text></text> </generalfeedback>\n<defaultgrade>1.0000000</defaultgrade>\n<penalty>0.3333333</penalty>\n<hidden>0</hidden>\n<idnumber></idnumber>\n<usecase>0</usecase>\n<answer fraction=\"100\" format=\"moodle_auto_format\">\n  <text>Addition</text>\n  <feedback format=\"html\">\n    <text></text>\n  </feedback>\n</answer>\n</question>\n<question type=\"ddwtos\">\n<name> <text>q_005_ddwtos_the_symbol_for_addition_is_1_the_sy</text> </name>\n<questiontext format=\"html\">\n  <text><![CDATA[\n     <!--  -->\n     <!--  -->\n     <p>The symbol for addition is [[1]], the symbol for subtraction is [[2]].</p>]]></text>\n     \n</questiontext>\n<generalfeedback format=\"html\"> <text></text> </generalfeedback>\n<defaultgrade>1</defaultgrade>\n<penalty>0.3333333</penalty>\n<hidden>0</hidden>\n<idnumber></idnumber>\n<shuffleanswers>1</shuffleanswers>\n<correctfeedback format=\"html\">\n  <text>Correct.</text>\n</correctfeedback>\n<partiallycorrectfeedback format=\"html\">\n  <text>Partially correct.</text>\n</partiallycorrectfeedback>\n<incorrectfeedback format=\"html\">\n  <text>Incorrect.</text>\n</incorrectfeedback>\n<shownumcorrect/>\n<dragbox>\n  <text>+</text>\n  <group>1</group>\n</dragbox>\n<dragbox>\n  <text>-</text>\n  <group>1</group>\n</dragbox>\n</question>\n<question type=\"gapselect\">\n<name> <text>q_006_gapselect_the_symbol_for_addition_is_1_the_sy</text> </name>\n<questiontext format=\"html\">\n  <text><![CDATA[\n     <!--  -->\n     <!--  -->\n     <p>The symbol for addition is [[1]], the symbol for subtraction is [[2]].</p>]]></text>\n     \n</questiontext>\n<generalfeedback format=\"html\"> <text></text> </generalfeedback>\n<defaultgrade>1</defaultgrade>\n<penalty>0.3333333</penalty>\n<hidden>0</hidden>\n<idnumber></idnumber>\n<shuffleanswers>1</shuffleanswers>\n<correctfeedback format=\"html\">\n  <text>Correct.</text>\n</correctfeedback>\n<partiallycorrectfeedback format=\"html\">\n  <text>Partially correct.</text>\n</partiallycorrectfeedback>\n<incorrectfeedback format=\"html\">\n  <text>Incorrect.</text>\n</incorrectfeedback>\n<shownumcorrect/>\n<selectoption>\n  <text>+</text>\n  <group>1</group>\n</selectoption>\n<selectoption>\n  <text>-</text>\n  <group>1</group>\n</selectoption>\n</question>\n<question type=\"ordering\">\n<name> <text>q_007_ordering_h_sort_the_result_from_smallest_to_largest</text> </name>\n<questiontext format=\"html\">\n  <text><![CDATA[\n     <!--  -->\n     <!--  -->\n     <p>Sort the result from smallest to largest.</p>]]></text>\n     \n</questiontext>\n<generalfeedback format=\"html\"> <text></text> </generalfeedback>\n<defaultgrade>1</defaultgrade>\n<penalty>0.3333333</penalty>\n<hidden>0</hidden>\n<idnumber></idnumber>\n<layouttype>HORIZONTAL</layouttype>\n<selecttype>ALL</selecttype>\n<selectcount>0</selectcount>\n<gradingtype>ABSOLUTE_POSITION</gradingtype>\n<showgrading>SHOW</showgrading>\n<numberingstyle>none</numberingstyle>\n<correctfeedback format=\"html\">\n  <text>Correct.</text>\n</correctfeedback>\n<partiallycorrectfeedback format=\"html\">\n  <text>Partially correct.</text>\n</partiallycorrectfeedback>\n<incorrectfeedback format=\"html\">\n  <text>Incorrect.</text>\n</incorrectfeedback>\n<shownumcorrect>1</shownumcorrect>\n<answer fraction=\"1.0000000\" format=\"moodle_auto_format\">\n  <text>6/2</text>\n</answer>\n<answer fraction=\"2.0000000\" format=\"moodle_auto_format\">\n  <text>6-2</text>\n</answer>\n<answer fraction=\"3.0000000\" format=\"moodle_auto_format\">\n  <text>6+2</text>\n</answer>\n<answer fraction=\"4.0000000\" format=\"moodle_auto_format\">\n  <text>6*2</text>\n</answer>\n    <hint format=\"html\">\n      <text></text>\n    </hint>\n    <hint format=\"html\">\n      <text></text>\n    </hint>\n</question>\n<question type=\"ordering\">\n<name> <text>q_008_ordering_v_sort_the_result_from_smallest_to_largest</text> </name>\n<questiontext format=\"html\">\n  <text><![CDATA[\n     <!--  -->\n     <!--  -->\n     <p>Sort the result from smallest to largest.</p>]]></text>\n     \n</questiontext>\n<generalfeedback format=\"html\"> <text></text> </generalfeedback>\n<defaultgrade>1</defaultgrade>\n<penalty>0.3333333</penalty>\n<hidden>0</hidden>\n<idnumber></idnumber>\n<layouttype>VERTICAL</layouttype>\n<selecttype>ALL</selecttype>\n<selectcount>0</selectcount>\n<gradingtype>ABSOLUTE_POSITION</gradingtype>\n<showgrading>SHOW</showgrading>\n<numberingstyle>none</numberingstyle>\n<correctfeedback format=\"html\">\n  <text>Correct.</text>\n</correctfeedback>\n<partiallycorrectfeedback format=\"html\">\n  <text>Partially correct.</text>\n</partiallycorrectfeedback>\n<incorrectfeedback format=\"html\">\n  <text>Incorrect.</text>\n</incorrectfeedback>\n<shownumcorrect>1</shownumcorrect>\n<answer fraction=\"1.0000000\" format=\"moodle_auto_format\">\n  <text>6/2</text>\n</answer>\n<answer fraction=\"2.0000000\" format=\"moodle_auto_format\">\n  <text>6-2</text>\n</answer>\n<answer fraction=\"3.0000000\" format=\"moodle_auto_format\">\n  <text>6+2</text>\n</answer>\n<answer fraction=\"4.0000000\" format=\"moodle_auto_format\">\n  <text>6*2</text>\n</answer>\n    <hint format=\"html\">\n      <text></text>\n    </hint>\n    <hint format=\"html\">\n      <text></text>\n    </hint>\n</question>\n<question type=\"numerical\">\n<name> <text>q_009_numerical_what_is_the_result_of_sqrt_4</text> </name>\n<questiontext format=\"html\">\n  <text><![CDATA[\n     <!--  -->\n     <!--  -->\n     <p>What is the result of SQRT(4)?</p>]]></text>\n     \n</questiontext>\n<generalfeedback format=\"html\"> <text></text> </generalfeedback>\n<defaultgrade>1</defaultgrade>\n<penalty>0.3333333</penalty>\n<hidden>0</hidden>\n<idnumber></idnumber>\n<answer fraction=\"100\" format=\"moodle_auto_format\">\n  <text>2</text>\n  <feedback format=\"html\">\n    <text></text>\n  </feedback>\n  <tolerance>0</tolerance>\n</answer>\n<answer fraction=\"100\" format=\"moodle_auto_format\">\n  <text>-2</text>\n  <feedback format=\"html\">\n    <text></text>\n  </feedback>\n  <tolerance>0</tolerance>\n</answer>\n    <unitgradingtype>0</unitgradingtype>\n    <unitpenalty>0.1000000</unitpenalty>\n    <showunits>3</showunits>\n    <unitsleft>0</unitsleft>\n</question>\n<question type=\"numerical\">\n<name> <text>q_010_numerical_what_is_the_result_of_4_3</text> </name>\n<questiontext format=\"html\">\n  <text><![CDATA[\n     <!--  -->\n     <!--  -->\n     <p>What is the result of 4/3?</p>]]></text>\n     \n</questiontext>\n<generalfeedback format=\"html\"> <text></text> </generalfeedback>\n<defaultgrade>1</defaultgrade>\n<penalty>0.3333333</penalty>\n<hidden>0</hidden>\n<idnumber></idnumber>\n<answer fraction=\"100\" format=\"moodle_auto_format\">\n  <text>1.33</text>\n  <feedback format=\"html\">\n    <text></text>\n  </feedback>\n  <tolerance>0.03</tolerance>\n</answer>\n    <unitgradingtype>0</unitgradingtype>\n    <unitpenalty>0.1000000</unitpenalty>\n    <showunits>3</showunits>\n    <unitsleft>0</unitsleft>\n</question>\n<question type=\"essay\">\n<name> <text>q_011_essay_describe_the_addition_operation</text> </name>\n<questiontext format=\"html\">\n  <text><![CDATA[\n     <!--  -->\n     <!--  -->\n     <p>Describe the addition operation.</p>]]></text>\n     \n</questiontext>\n<generalfeedback format=\"html\"> <text></text> </generalfeedback>\n<defaultgrade>1</defaultgrade>\n<penalty>0</penalty>\n<hidden>0</hidden>\n<idnumber></idnumber>\n<responseformat>editor</responseformat>\n<responserequired>1</responserequired>\n<responsefieldlines>10</responsefieldlines>\n<minwordlimit></minwordlimit>\n<maxwordlimit></maxwordlimit>\n<attachments>0</attachments>\n<attachmentsrequired>0</attachmentsrequired>\n<maxbytes>0</maxbytes>\n<filetypeslist></filetypeslist>\n<graderinfo format=\"html\">\n  <text></text>\n</graderinfo>\n<responsetemplate format=\"html\">\n  <text></text>\n</responsetemplate>\n</question>\n</quiz>",
      class = c("glue",
                "character")
    )
  )

  # expect_equal(nchar(xml3), 174824)


})
