% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monolix2rx.R
\name{monolix2rx}
\alias{monolix2rx}
\title{Translate a monolix file to rxode2}
\usage{
monolix2rx(
  mlxtran,
  update = TRUE,
  thetaMatType = c("sa", "lin"),
  sd = 1,
  cor = 1e-05,
  theta = 0.5,
  ci = 0.95,
  sigdig = 3,
  envir = parent.frame()
)
}
\arguments{
\item{mlxtran}{file name for mlxtran to translate to rxode2}

\item{update}{is a boolean that represents if the final parameter
estimates should be used for the translation (when present)}

\item{thetaMatType}{This lists the preferred source for \code{thetaMat}
covariance matrix.  By default it is \code{sa} for simulated
annealing, though you could use \code{lin} for linearized covariance
calculation. If only one is present, then use whatever is present}

\item{sd}{Default standard deviation for between subject
variability/inter-occasion variability that are missing.}

\item{cor}{Default correlation for missing correlations estimate}

\item{theta}{default population estimate}

\item{ci}{confidence interval for validation, by default 0.95}

\item{sigdig}{number of significant digits for validation, by default 3}

\item{envir}{represents the environment used for evaluating the
corresponding rxode2 function}
}
\value{
rxode2 model
}
\description{
Translate a monolix file to rxode2
}
\examples{
# First load in the model; in this case the theo model
# This is modified from the Monolix demos by saving the model
# File as a text file (hence you can access without model library)
# setup.
#
# This example is also included in the monolix2rx package, so
# you refer to the location with `system.file()`:

pkgTheo <- system.file("theo", package="monolix2rx")

rx <- monolix2rx(file.path(pkgTheo, "theophylline_project.mlxtran"))

pkgCov <- system.file("cov", package="monolix2rx")

rx <- monolix2rx(file.path(pkgCov, "warfarin_covariate3_project.mlxtran"))

rx
}
\author{
Matthew L. Fidler
}
