% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{mongo_options}
\alias{mongo_options}
\title{Mongo Options}
\usage{
mongo_options(log_level = NULL, bigint_as_char = NULL,
  date_as_char = NULL)
}
\arguments{
\item{log_level}{integer between 0 and 6 or \code{NULL} to leave unchanged.}

\item{bigint_as_char}{logical: parse int64 as strings instead of double.}

\item{date_as_char}{logical: parse UTC datetime as strings instead of POSIXct.}
}
\description{
Get and set global client options. Calling with \code{NULL} parameters returns current
values without modifying.
}
\details{
Setting \href{http://mongoc.org/libmongoc/current/logging.html}{log_level} to 0 suppresses
critical warnings and messages, while 6 is  most verbose and displays all debugging
information. Possible values for level are:
\itemize{
\item \code{0}: \emph{error}
\item \code{1}: \emph{critical}
\item \code{2}: \emph{warning}
\item \code{3}: \emph{message}
\item \code{4}: \emph{info} (\strong{default})
\item \code{5}: \emph{debug}
\item \code{6}: \emph{trace}
}

Note that setting it below 2 will suppress important warnings and setting
below 1 will suppress critical errors (not recommended). The default is 4.
}
