% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_download_data.R
\name{mf_download_data}
\alias{mf_download_data}
\title{Download several datasets given their URLs and destination path}
\usage{
mf_download_data(
  df_to_dl,
  path = tempfile("modisfast_"),
  parallel = FALSE,
  num_workers = parallel::detectCores() - 1,
  credentials = NULL,
  verbose = TRUE,
  min_filesize = 5000
)
}
\arguments{
\item{df_to_dl}{data.frame. Urls and destination files of dataset to download. Typically output of \link{mf_get_url}. See Details for the structure}

\item{path}{string. Target folder for the data to download. Default : temporary folder.}

\item{parallel}{boolean. Parallelize the download ? Default to FALSE}

\item{num_workers}{integer. Number of workers in case of parallel download. Default to number of workers available in the machine minus one.}

\item{credentials}{vector string of length 2 with username and password. optional if the function \link{mf_login} was previously executed.}

\item{verbose}{boolean. optional. Verbose (default TRUE)}

\item{min_filesize}{integer. Minimum file size expected (in bites) for one file downloaded. If files downloaded are less that this value, the files will be downloaded again. Default 5000.}
}
\value{
a data.frame with the same structure of the input data.frame \code{df_to_dl} + columns providing details of the data downloaded. The additional columns are :
\describe{
\item{fileDl}{Booloean (dataset downloaded or failure)}
\item{dlStatus}{Download status : 1 = download ok ; 2 = download error ; 3 = dataset was already existing in destination file }
\item{fileSize}{File size on disk}
}
}
\description{
This function enables to download datasets. In a data import workflow, this function is typically used after a call to the \link{mf_get_url} function. The output value of \link{mf_get_url} can be used as input of parameter \code{df_to_dl} of \link{mf_download_data}.

The download can the parallelized.
}
\details{
Parameter \code{df_to_dl} must be a data.frame with the following minimal structure :
\describe{
\item{id_roi}{An id for the ROI (character string)}
\item{collection}{Collection (character string)}
\item{name}{}
\item{url}{URL of the file to download (character string)}
}
}
\examples{

\dontrun{

### Login to EOSDIS Earthdata with your username and password
log <- mf_login(credentials = c("earthdata_un","earthdata_pw"))

### Set-up parameters of interest
coll <- "MOD11A1.061"

bands <- c("LST_Day_1km","LST_Night_1km")

time_range <- as.Date(c("2017-01-01","2017-01-30"))

roi <- sf::st_as_sf(data.frame(
id = "roi_test",
geom="POLYGON ((-5.82 9.54, -5.42 9.55, -5.41 8.84, -5.81 8.84, -5.82 9.54))"),
wkt="geom",crs = 4326)

### Get the URLs of the data
(urls_mod11a1 <- mf_get_url(
collection = coll,
variables = bands,
roi = roi,
time_range = time_range
))

### Download the data
res_dl <- mf_download_data(urls_mod11a1)

### Import the data as terra::SpatRast
modis_ts <- mf_import_data(dirname(res_dl$destfile[1]), collection = coll)

### Plot the data
terra::plot(modis_ts)

}
}
