% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-fit-workflowset.R
\name{create_model_grid}
\alias{create_model_grid}
\title{Helper to make \code{parsnip} model specs from a \code{dials} parameter grid}
\usage{
create_model_grid(grid, f_model_spec, engine_name, ..., engine_params = list())
}
\arguments{
\item{grid}{A tibble that forms a grid of parameters to adjust}

\item{f_model_spec}{A function name (quoted or unquoted) that
specifies a \code{parsnip} model specification function}

\item{engine_name}{A name of an engine to use. Gets passed to \code{parsnip::set_engine()}.}

\item{...}{Static parameters that get passed to the f_model_spec}

\item{engine_params}{A \code{list} of additional parameters that can be passed to the
engine via \code{parsnip::set_engine(...)}.}
}
\value{
Tibble with a new colum named \code{.models}
}
\description{
Helper to make \code{parsnip} model specs from a \code{dials} parameter grid
}
\details{
This is a helper function that combines \code{dials} grids with
\code{parsnip} model specifications. The intent is to make it easier
to generate \code{workflowset} objects for forecast evaluations
with \code{modeltime_fit_workflowset()}.

The process follows:
\enumerate{
\item Generate a grid (hyperparemeter combination)
\item Use \code{create_model_grid()} to apply the parameter combinations to
a parsnip model spec and engine.
}

The output contains ".model" column that can be used as a list
of models inside the \code{workflow_set()} function.
}
\examples{

library(tidymodels)
library(modeltime)

# Parameters that get optimized
grid_tbl <- grid_regular(
    learn_rate(),
    levels = 3
)

# Generate model specs
grid_tbl \%>\%
    create_model_grid(
        f_model_spec = boost_tree,
        engine_name  = "xgboost",
        # Static boost_tree() args
        mode = "regression",
        # Static set_engine() args
        engine_params = list(
            max_depth = 5
        )
    )

}
\seealso{
\itemize{
\item \code{\link[dials:grid_regular]{dials::grid_regular()}}: For making parameter grids.
\item \code{\link[workflowsets:workflow_set]{workflowsets::workflow_set()}}: For creating a \code{workflowset} from the \code{.models} list stored in the ".models" column.
\item \code{\link[=modeltime_fit_workflowset]{modeltime_fit_workflowset()}}: For fitting a \code{workflowset} to forecast data.
}
}
