% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-arima_boost.R
\name{auto_arima_xgboost_fit_impl}
\alias{auto_arima_xgboost_fit_impl}
\title{Bridge ARIMA-XGBoost Modeling function}
\usage{
auto_arima_xgboost_fit_impl(
  x,
  y,
  period = "auto",
  max.p = 5,
  max.d = 2,
  max.q = 5,
  max.P = 2,
  max.D = 1,
  max.Q = 2,
  max.order = 5,
  d = NA,
  D = NA,
  start.p = 2,
  start.q = 2,
  start.P = 1,
  start.Q = 1,
  stationary = FALSE,
  seasonal = TRUE,
  ic = c("aicc", "aic", "bic"),
  stepwise = TRUE,
  nmodels = 94,
  trace = FALSE,
  approximation = (length(x) > 150 | frequency(x) > 12),
  method = NULL,
  truncate = NULL,
  test = c("kpss", "adf", "pp"),
  test.args = list(),
  seasonal.test = c("seas", "ocsb", "hegy", "ch"),
  seasonal.test.args = list(),
  allowdrift = TRUE,
  allowmean = TRUE,
  lambda = NULL,
  biasadj = FALSE,
  max_depth = 6,
  nrounds = 15,
  eta = 0.3,
  colsample_bytree = 1,
  min_child_weight = 1,
  gamma = 0,
  subsample = 1,
  validation = 0,
  early_stop = NULL,
  ...
)
}
\arguments{
\item{x}{A dataframe of xreg (exogenous regressors)}

\item{y}{A numeric vector of values to fit}

\item{period}{A seasonal frequency. Uses "auto" by default. A character phrase
of "auto" or time-based phrase of "2 weeks" can be used if a date or date-time variable is provided.}

\item{max.p}{The maximum order of the non-seasonal auto-regressive (AR) terms.}

\item{max.d}{The maximum order of integration for non-seasonal differencing.}

\item{max.q}{The maximum order of the non-seasonal moving average (MA) terms.}

\item{max.P}{The maximum order of the seasonal auto-regressive (SAR) terms.}

\item{max.D}{The maximum order of integration for seasonal differencing.}

\item{max.Q}{The maximum order of the seasonal moving average (SMA) terms.}

\item{max.order}{Maximum value of p+q+P+Q if model selection is not
stepwise.}

\item{d}{Order of first-differencing. If missing, will choose a value based
on \code{test}.}

\item{D}{Order of seasonal-differencing. If missing, will choose a value
based on \code{season.test}.}

\item{start.p}{Starting value of p in stepwise procedure.}

\item{start.q}{Starting value of q in stepwise procedure.}

\item{start.P}{Starting value of P in stepwise procedure.}

\item{start.Q}{Starting value of Q in stepwise procedure.}

\item{stationary}{If \code{TRUE}, restricts search to stationary models.}

\item{seasonal}{If \code{FALSE}, restricts search to non-seasonal models.}

\item{ic}{Information criterion to be used in model selection.}

\item{stepwise}{If \code{TRUE}, will do stepwise selection (faster).
Otherwise, it searches over all models. Non-stepwise selection can be very
slow, especially for seasonal models.}

\item{nmodels}{Maximum number of models considered in the stepwise search.}

\item{trace}{If \code{TRUE}, the list of ARIMA models considered will be
reported.}

\item{approximation}{If \code{TRUE}, estimation is via conditional sums of
squares and the information criteria used for model selection are
approximated. The final model is still computed using maximum likelihood
estimation. Approximation should be used for long time series or a high
seasonal period to avoid excessive computation times.}

\item{method}{fitting method: maximum likelihood or minimize
    conditional sum-of-squares.  The default (unless there are missing
    values) is to use conditional-sum-of-squares to find starting
    values, then maximum likelihood.  Can be abbreviated.}

\item{truncate}{An integer value indicating how many observations to use in
model selection. The last \code{truncate} values of the series are used to
select a model when \code{truncate} is not \code{NULL} and
\code{approximation=TRUE}. All observations are used if either
\code{truncate=NULL} or \code{approximation=FALSE}.}

\item{test}{Type of unit root test to use. See \code{\link[forecast]{ndiffs}} for
details.}

\item{test.args}{Additional arguments to be passed to the unit root test.}

\item{seasonal.test}{This determines which method is used to select the number of seasonal differences.
The default method is to use a measure of seasonal strength computed from an STL decomposition.
Other possibilities involve seasonal unit root tests.}

\item{seasonal.test.args}{Additional arguments to be passed to the seasonal
unit root test.
See \code{\link[forecast]{nsdiffs}} for details.}

\item{allowdrift}{If \code{TRUE}, models with drift terms are considered.}

\item{allowmean}{If \code{TRUE}, models with a non-zero mean are considered.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda="auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted values,
a regular back transformation will result in median forecasts. If biasadj is TRUE,
an adjustment will be made to produce mean forecasts and fitted values.}

\item{max_depth}{An integer for the maximum depth of the tree.}

\item{nrounds}{An integer for the number of boosting iterations.}

\item{eta}{A numeric value between zero and one to control the learning rate.}

\item{colsample_bytree}{Subsampling proportion of columns.}

\item{min_child_weight}{A numeric value for the minimum sum of instance
weights needed in a child to continue to split.}

\item{gamma}{A number for the minimum loss reduction required to make a
further partition on a leaf node of the tree}

\item{subsample}{Subsampling proportion of rows.}

\item{validation}{A positive number. If on \verb{[0, 1)} the value, \code{validation}
is a random proportion of data in \code{x} and \code{y} that are used for performance
assessment and potential early stopping. If 1 or greater, it is the \emph{number}
of training set samples use for these purposes.}

\item{early_stop}{An integer or \code{NULL}. If not \code{NULL}, it is the number of
training iterations without improvement before stopping. If \code{validation} is
used, performance is base on the validation set; otherwise the training set
is used.}

\item{...}{Additional arguments passed to \code{xgboost::xgb.train}}
}
\description{
Bridge ARIMA-XGBoost Modeling function
}
