% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsummary_wide.R
\name{modelsummary_wide}
\alias{modelsummary_wide}
\title{Superseded function}
\usage{
modelsummary_wide(
  models,
  output = "default",
  fmt = 3,
  estimate = "estimate",
  statistic = "std.error",
  vcov = NULL,
  conf_level = 0.95,
  stars = FALSE,
  coef_group = NULL,
  coef_map = NULL,
  coef_omit = NULL,
  coef_rename = NULL,
  gof_map = NULL,
  gof_omit = NULL,
  add_rows = NULL,
  align = NULL,
  notes = NULL,
  title = NULL,
  stacking = "horizontal",
  ...
)
}
\arguments{
\item{models}{a model or (optionally named) list of models}

\item{output}{filename or object type (character string)
\itemize{
\item Supported filename extensions: .docx, .html, .tex, .md, .txt, .png, .jpg.
\item Supported object types: "default", "html", "markdown", "latex", "latex_tabular", "data.frame", "gt", "kableExtra", "huxtable", "flextable", "jupyter". The "modelsummary_list" value produces a lightweight object which can be saved and fed back to the \code{modelsummary} function.
\item Warning: Users should not supply a file name to the \code{output} argument if they intend to customize the table with external packages. See the 'Details' section.
\item LaTeX compilation requires the \code{booktabs} and \code{siunitx} packages, but \code{siunitx} can be disabled or replaced with global options. See the 'Details' section.
\item The default output formats and table-making packages can be modified with global options. See the 'Details' section.
}}

\item{fmt}{determines how to format numeric values
\itemize{
\item integer: the number of digits to keep after the period \code{format(round(x, fmt), nsmall=fmt)}
\item character: passed to the \code{sprintf} function (e.g., '\%.3f' keeps 3 digits with trailing zero). See \code{?sprintf}
\item function: returns a formatted character string.
\item LaTeX output: To ensure proper typography, all numeric entries are enclosed in the \verb{\\num\{\}} command, which requires the \code{siunitx} package to be loaded in the LaTeX preamble. This behavior can be altered with global options. See the 'Details' section.
}}

\item{estimate}{string or \code{glue} string of the estimate to display (or a
vector with one string per model). Valid entries include any column name of
the data.frame produced by \code{get_estimates(model)}. Examples:
\itemize{
\item \code{"estimate"}
\item \code{"{estimate} ({std.error}){stars}"}
\item \code{"{estimate} [{conf.low}, {conf.high}]"}
}}

\item{statistic}{vector of strings or \code{glue} strings which select uncertainty
statistics to report vertically below the estimate. NULL omits all
uncertainty statistics.
\itemize{
\item "conf.int", "std.error", "statistic", "p.value", "conf.low", "conf.high",
or any column name produced by: \code{get_estimates(model)}
\item \code{glue} package strings with braces, such as:
\itemize{
\item \code{"{p.value} [{conf.low}, {conf.high}]"}
\item \code{"Std.Error: {std.error}"}
}
\item Parentheses are added automatically unless the string includes \code{glue} curly braces \code{{}}.
}}

\item{vcov}{robust standard errors and other manual statistics. The \code{vcov}
argument accepts six types of input (see the 'Details' and 'Examples'
sections below):
\itemize{
\item NULL returns the default uncertainty estimates of the model object
\item string, vector, or (named) list of strings. "iid", "classical", and "constant" are aliases for \code{NULL}, which returns the model's default uncertainty estimates. The strings "HC", "HC0", "HC1" (alias: "stata"), "HC2", "HC3" (alias: "robust"), "HC4", "HC4m", "HC5", "HAC", "NeweyWest", "Andrews", "panel-corrected", "outer-product", and "weave" use variance-covariance matrices computed using functions from the \code{sandwich} package, or equivalent method. The behavior of those functions can (and sometimes \emph{must}) be altered by passing arguments to \code{sandwich} directly from \code{modelsummary} through the ellipsis (\code{...}), but it is safer to define your own custom functions as described in the next bullet.
\item function or (named) list of functions which return variance-covariance matrices with row and column names equal to the names of your coefficient estimates (e.g., \code{stats::vcov}, \code{sandwich::vcovHC}, \code{function(x) vcovPC(x, cluster="country")}).
\item formula or (named) list of formulas with the cluster variable(s) on the right-hand side (e.g., ~clusterid).
\item named list of \code{length(models)} variance-covariance matrices with row and column names equal to the names of your coefficient estimates.
\item a named list of length(models) vectors with names equal to the names of your coefficient estimates. See 'Examples' section below. Warning: since this list of vectors can include arbitrary strings or numbers, \code{modelsummary} cannot automatically calculate p values. The \code{stars} argument may thus use incorrect significance thresholds when \code{vcov} is a list of vectors.
}}

\item{conf_level}{confidence level to use for confidence intervals}

\item{stars}{to indicate statistical significance
\itemize{
\item FALSE (default): no significance stars.
\item TRUE: +=.1, *=.05, **=.01, ***=0.001
\item Named numeric vector for custom stars such as \code{c('*' = .1, '+' = .05)}
\item Note: a legend will not be inserted at the bottom of the table when the \code{estimate} or \code{statistic} arguments use "glue strings" with \code{{stars}}.
}}

\item{coef_group}{the name of the coefficient groups to use as columns (NULL
or character). If \code{coef_group} is NULL, \code{modelsummary} tries to guess the
correct coefficient group identifier. To be valid, this identifier must
be a column in the data.frame produced by \code{get_estimates(model)}.}

\item{coef_map}{character vector. Subset, rename, and reorder coefficients.
Coefficients omitted from this vector are omitted from the table. The order
of the vector determines the order of the table.  \code{coef_map} can be a named
or an unnamed character vector (see the Examples section below). If
\code{coef_map} is a named vector, its values define the labels that must appear
in the table, and its names identify the original term names stored in the
model object: \code{c("hp:mpg"="HPxM/G")}.}

\item{coef_omit}{string regular expression. Omits all matching coefficients
from the table using \code{grepl(perl=TRUE)}. This argument uses perl-compatible regular expressions, which allows expressions such as \verb{"Int|ABC" which omits coefficients matching either "Int" or "ABC", and }"^(?!.*Intercept)"` which omits every term except the intercept.}

\item{coef_rename}{named character vector or function which returns a named
vector. Values of the vector refer to the variable names that will appear
in the table. Names refer to the original term names stored in the model
object, e.g. c("hp:mpg"="hp X mpg") for an interaction term.
If you provide a function to \code{coef_rename}, \code{modelsummary} will create a named
vector for you by deriving the new variable names from the vector of original
term names with your function.}

\item{gof_map}{rename, reorder, and omit goodness-of-fit statistics and other
model information. This argument accepts 3 types of values:
\itemize{
\item NULL (default): the \code{modelsummary::gof_map} dictionary is used for formatting, and all unknown statistic are included.
\item data.frame with 3 columns named "raw", "clean", "fmt". Unknown statistics are omitted. See the 'Examples' section below.
\item list of lists, each of which includes 3 elements named "raw", "clean", "fmt". Unknown statistics are omitted. See the 'Examples section below'.
}}

\item{gof_omit}{string regular expression. Omits all matching gof statistics from
the table. This argument uses perl-compatible regular expressions (\code{grepl(perl=TRUE)}), which allows expressions such as \code{".*"} which omits everything, and \code{"^(?!R2|Num)"} which omits every term except those that start with "R2" or "Num".}

\item{add_rows}{a data.frame (or tibble) with the same number of columns as
your main table. By default, rows are appended to the bottom of the table.
You can define a "position" attribute of integers to set the row positions.
See Examples section below.}

\item{align}{A string with a number of characters equal to the number of columns in
the table (e.g., \code{align = "lcc"}).  Valid characters: l, c, r, S.
\itemize{
\item "l": left-aligned column
\item "c": centered column
\item "r": right-aligned column
\item "d": dot-aligned column. Only supported for LaTeX/PDF tables produced by \code{kableExtra}. These commands must appear in the LaTeX preamble (they are added automatically when compiling Rmarkdown documents to PDF):
\itemize{
\item \verb{\\usepackage\{booktabs\}}
\item \verb{\\usepackage\{siunitx\}}
\item \verb{\\newcolumntype\{d\}\{S[input-symbols = ()]\}}
}
}}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{title}{string}

\item{stacking}{direction in which models are stacked: "horizontal" or
"vertical"}

\item{...}{all other arguments are passed through to the extractor and
table-making functions. This allows users to pass arguments directly to
\code{modelsummary} in order to affect the behavior of other functions behind
the scenes. Examples include:
\itemize{
\item \code{broom::tidy(exponentiate=TRUE)} to exponentiate logistic regression. Please see the \code{modelsummary} vignette on the package website for important technical notes on this topic.
\item \code{performance::model_performance(metrics="RMSE")} to select goodness-of-fit statistics to extract using the \code{performance} package (must have set \code{options(modelsummary_get="easystats")} first).
}}
}
\value{
a regression table in a format determined by the \code{output} argument.
}
\description{
This function is superseded by the \code{group} argument of the \code{modelsummary} function.
}
\keyword{internal}
