% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_estimates.R
\name{get_estimates}
\alias{get_estimates}
\title{Extract model estimates. A mostly internal function with some potential uses
outside.}
\usage{
get_estimates(model, conf_level = 0.95, vcov = NULL, ...)
}
\arguments{
\item{model}{a single model object}

\item{conf_level}{confidence level to use for confidence intervals}

\item{vcov}{robust standard errors and other manual statistics. The \code{vcov}
argument accepts five types of input (see the 'Details' and 'Examples'
sections below):
\itemize{
\item string, vector, or list of strings: "robust", "HC", "HC0", "HC1", "HC2", "HC3", "HC4", "HC4m", "HC5", "stata", or "classical" (alias "constant" or "iid").
\item formula or list of formulas with the cluster variable(s) on the right-hand side (e.g., ~clusterid).
\item function or list of functions which return variance-covariance matrices with row and column names equal to the names of your coefficient estimates (e.g., \code{stats::vcov}, \code{sandwich::vcovHC}).
\item list of \code{length(models)} variance-covariance matrices with row and column names equal to the names of your coefficient estimates.
\item a list of length(models) vectors with names equal to the names of your coefficient estimates. See 'Examples' section below. Warning: since this list of vectors can include arbitrary strings or numbers, \code{modelsummary} cannot automatically calculate p values. The \code{stars} argument may thus use incorrect significance thresholds when \code{vcov} is a list of vectors.
}}

\item{...}{all other arguments are passed through to the extractor and
table-making functions. This allows users to pass arguments directly to
\code{modelsummary} in order to affect the behavior of other functions behind
the scenes. Examples include:
\itemize{
\item \code{broom::tidy(exponentiate=TRUE)} to exponentiate logistic regression
\item \code{kableExtra::kbl(escape=FALSE)} to avoid escaping math characters in \code{kableExtra} tables.
\item \code{performance::model_performance(metrics="RMSE")} to select goodness-of-fit statistics to extract using the \code{performance} package (must have set \code{options(modelsummary_get="easystats")} first).
}}
}
\description{
Extract model estimates. A mostly internal function with some potential uses
outside.
}
