% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ames.R
\name{data_ames}
\alias{data_ames}
\title{Ames data set}
\source{
De Cock, D. (2011). "Ames, Iowa: Alternative to the Boston Housing Data as an
End of Semester Regression Project," \emph{Journal of Statistics Education},
Volume 19, Number 3.

\url{http://jse.amstat.org/v19n3/decock/DataDocumentation.txt}

\url{http://jse.amstat.org/v19n3/decock.pdf}
}
\usage{
data_ames(...)
}
\arguments{
\item{...}{Arguments passed to \code{\link[pins:pin_read]{pins::pin_read()}}.}
}
\value{
tibble
}
\description{
#' A data set from De Cock (2011) has 82 fields were recorded for 2,930
properties in Ames IA. This version is copies from the \code{AmesHousing} package
but does not include a few quality columns that appear to be outcomes
rather than predictors.

See this links for the sources below for more information as well as
\code{?AmesHousing::make_ames}.
}
\details{
The full data dictionary can be found here
\url{https://jse.amstat.org/v19n3/decock/DataDocumentation.txt}.
}
\section{tibble print}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{data_ames()
#> # A tibble: 2,930 x 74
#>    ms_sub_class           ms_zoning lot_frontage lot_area street alley lot_shape
#>  * <fct>                  <fct>            <dbl>    <int> <fct>  <fct> <fct>    
#>  1 One_Story_1946_and_Ne~ Resident~          141    31770 Pave   No_A~ Slightly~
#>  2 One_Story_1946_and_Ne~ Resident~           80    11622 Pave   No_A~ Regular  
#>  3 One_Story_1946_and_Ne~ Resident~           81    14267 Pave   No_A~ Slightly~
#>  4 One_Story_1946_and_Ne~ Resident~           93    11160 Pave   No_A~ Regular  
#>  5 Two_Story_1946_and_Ne~ Resident~           74    13830 Pave   No_A~ Slightly~
#>  6 Two_Story_1946_and_Ne~ Resident~           78     9978 Pave   No_A~ Slightly~
#>  7 One_Story_PUD_1946_an~ Resident~           41     4920 Pave   No_A~ Regular  
#>  8 One_Story_PUD_1946_an~ Resident~           43     5005 Pave   No_A~ Slightly~
#>  9 One_Story_PUD_1946_an~ Resident~           39     5389 Pave   No_A~ Slightly~
#> 10 Two_Story_1946_and_Ne~ Resident~           60     7500 Pave   No_A~ Regular  
#> # i 2,920 more rows
#> # i 67 more variables: land_contour <fct>, utilities <fct>, lot_config <fct>,
#> #   land_slope <fct>, neighborhood <fct>, condition_1 <fct>, condition_2 <fct>,
#> #   bldg_type <fct>, house_style <fct>, overall_cond <fct>, year_built <int>,
#> #   year_remod_add <int>, roof_style <fct>, roof_matl <fct>,
#> #   exterior_1st <fct>, exterior_2nd <fct>, mas_vnr_type <fct>,
#> #   mas_vnr_area <dbl>, exter_cond <fct>, foundation <fct>, ...
}\if{html}{\out{</div>}}
}

\section{glimpse()}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{tibble::glimpse(data_ames())
#> Rows: 2,930
#> Columns: 74
#> $ ms_sub_class       <fct> One_Story_1946_and_Newer_All_Styles, One_Story_1946~
#> $ ms_zoning          <fct> Residential_Low_Density, Residential_High_Density, ~
#> $ lot_frontage       <dbl> 141, 80, 81, 93, 74, 78, 41, 43, 39, 60, 75, 0, 63,~
#> $ lot_area           <int> 31770, 11622, 14267, 11160, 13830, 9978, 4920, 5005~
#> $ street             <fct> Pave, Pave, Pave, Pave, Pave, Pave, Pave, Pave, Pav~
#> $ alley              <fct> No_Alley_Access, No_Alley_Access, No_Alley_Access, ~
#> $ lot_shape          <fct> Slightly_Irregular, Regular, Slightly_Irregular, Re~
#> $ land_contour       <fct> Lvl, Lvl, Lvl, Lvl, Lvl, Lvl, Lvl, HLS, Lvl, Lvl, L~
#> $ utilities          <fct> AllPub, AllPub, AllPub, AllPub, AllPub, AllPub, All~
#> $ lot_config         <fct> Corner, Inside, Corner, Corner, Inside, Inside, Ins~
#> $ land_slope         <fct> Gtl, Gtl, Gtl, Gtl, Gtl, Gtl, Gtl, Gtl, Gtl, Gtl, G~
#> $ neighborhood       <fct> North_Ames, North_Ames, North_Ames, North_Ames, Gil~
#> $ condition_1        <fct> Norm, Feedr, Norm, Norm, Norm, Norm, Norm, Norm, No~
#> $ condition_2        <fct> Norm, Norm, Norm, Norm, Norm, Norm, Norm, Norm, Nor~
#> $ bldg_type          <fct> OneFam, OneFam, OneFam, OneFam, OneFam, OneFam, Twn~
#> $ house_style        <fct> One_Story, One_Story, One_Story, One_Story, Two_Sto~
#> $ overall_cond       <fct> Average, Above_Average, Above_Average, Average, Ave~
#> $ year_built         <int> 1960, 1961, 1958, 1968, 1997, 1998, 2001, 1992, 199~
#> $ year_remod_add     <int> 1960, 1961, 1958, 1968, 1998, 1998, 2001, 1992, 199~
#> $ roof_style         <fct> Hip, Gable, Hip, Hip, Gable, Gable, Gable, Gable, G~
#> $ roof_matl          <fct> CompShg, CompShg, CompShg, CompShg, CompShg, CompSh~
#> $ exterior_1st       <fct> BrkFace, VinylSd, Wd Sdng, BrkFace, VinylSd, VinylS~
#> $ exterior_2nd       <fct> Plywood, VinylSd, Wd Sdng, BrkFace, VinylSd, VinylS~
#> $ mas_vnr_type       <fct> Stone, None, BrkFace, None, None, BrkFace, None, No~
#> $ mas_vnr_area       <dbl> 112, 0, 108, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6~
#> $ exter_cond         <fct> Typical, Typical, Typical, Typical, Typical, Typica~
#> $ foundation         <fct> CBlock, CBlock, CBlock, CBlock, PConc, PConc, PConc~
#> $ bsmt_cond          <fct> Good, Typical, Typical, Typical, Typical, Typical, ~
#> $ bsmt_exposure      <fct> Gd, No, No, No, No, No, Mn, No, No, No, No, No, No,~
#> $ bsmt_fin_type_1    <fct> BLQ, Rec, ALQ, ALQ, GLQ, GLQ, GLQ, ALQ, GLQ, Unf, U~
#> $ bsmt_fin_sf_1      <dbl> 2, 6, 1, 1, 3, 3, 3, 1, 3, 7, 7, 1, 7, 3, 3, 1, 3, ~
#> $ bsmt_fin_type_2    <fct> Unf, LwQ, Unf, Unf, Unf, Unf, Unf, Unf, Unf, Unf, U~
#> $ bsmt_fin_sf_2      <dbl> 0, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1120, 0~
#> $ bsmt_unf_sf        <dbl> 441, 270, 406, 1045, 137, 324, 722, 1017, 415, 994,~
#> $ total_bsmt_sf      <dbl> 1080, 882, 1329, 2110, 928, 926, 1338, 1280, 1595, ~
#> $ heating            <fct> GasA, GasA, GasA, GasA, GasA, GasA, GasA, GasA, Gas~
#> $ heating_qc         <fct> Fair, Typical, Typical, Excellent, Good, Excellent,~
#> $ central_air        <fct> Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, ~
#> $ electrical         <fct> SBrkr, SBrkr, SBrkr, SBrkr, SBrkr, SBrkr, SBrkr, SB~
#> $ first_flr_sf       <int> 1656, 896, 1329, 2110, 928, 926, 1338, 1280, 1616, ~
#> $ second_flr_sf      <int> 0, 0, 0, 0, 701, 678, 0, 0, 0, 776, 892, 0, 676, 0,~
#> $ gr_liv_area        <int> 1656, 896, 1329, 2110, 1629, 1604, 1338, 1280, 1616~
#> $ bsmt_full_bath     <dbl> 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, ~
#> $ bsmt_half_bath     <dbl> 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ~
#> $ full_bath          <int> 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 3, 2, ~
#> $ half_bath          <int> 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, ~
#> $ bedroom_abv_gr     <int> 3, 2, 3, 3, 3, 3, 2, 2, 2, 3, 3, 3, 3, 2, 1, 4, 4, ~
#> $ kitchen_abv_gr     <int> 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, ~
#> $ tot_rms_abv_grd    <int> 7, 5, 6, 8, 6, 7, 6, 5, 5, 7, 7, 6, 7, 5, 4, 12, 8,~
#> $ functional         <fct> Typ, Typ, Typ, Typ, Typ, Typ, Typ, Typ, Typ, Typ, T~
#> $ fireplaces         <int> 2, 0, 0, 2, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, ~
#> $ garage_type        <fct> Attchd, Attchd, Attchd, Attchd, Attchd, Attchd, Att~
#> $ garage_finish      <fct> Fin, Unf, Unf, Fin, Fin, Fin, Fin, RFn, RFn, Fin, F~
#> $ garage_cars        <dbl> 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, ~
#> $ garage_area        <dbl> 528, 730, 312, 522, 482, 470, 582, 506, 608, 442, 4~
#> $ garage_cond        <fct> Typical, Typical, Typical, Typical, Typical, Typica~
#> $ paved_drive        <fct> Partial_Pavement, Paved, Paved, Paved, Paved, Paved~
#> $ wood_deck_sf       <int> 210, 140, 393, 0, 212, 360, 0, 0, 237, 140, 157, 48~
#> $ open_porch_sf      <int> 62, 0, 36, 0, 34, 36, 0, 82, 152, 60, 84, 21, 75, 0~
#> $ enclosed_porch     <int> 0, 0, 0, 0, 0, 0, 170, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0~
#> $ three_season_porch <int> 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ~
#> $ screen_porch       <int> 0, 120, 0, 0, 0, 0, 0, 144, 0, 0, 0, 0, 0, 0, 140, ~
#> $ pool_area          <int> 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ~
#> $ pool_qc            <fct> No_Pool, No_Pool, No_Pool, No_Pool, No_Pool, No_Poo~
#> $ fence              <fct> No_Fence, Minimum_Privacy, No_Fence, No_Fence, Mini~
#> $ misc_feature       <fct> None, None, Gar2, None, None, None, None, None, Non~
#> $ misc_val           <int> 0, 0, 12500, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, 0, 0, ~
#> $ mo_sold            <int> 5, 6, 6, 4, 3, 6, 4, 1, 3, 6, 4, 3, 5, 2, 6, 6, 6, ~
#> $ year_sold          <int> 2010, 2010, 2010, 2010, 2010, 2010, 2010, 2010, 201~
#> $ sale_type          <fct> WD , WD , WD , WD , WD , WD , WD , WD , WD , WD , W~
#> $ sale_condition     <fct> Normal, Normal, Normal, Normal, Normal, Normal, Nor~
#> $ sale_price         <int> 215000, 105000, 172000, 244000, 189900, 195500, 213~
#> $ longitude          <dbl> -93.61975, -93.61976, -93.61939, -93.61732, -93.638~
#> $ latitude           <dbl> 42.05403, 42.05301, 42.05266, 42.05125, 42.06090, 4~
}\if{html}{\out{</div>}}
}

\examples{
\donttest{
data_ames()
}
}
