% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanshift.R
\name{meanshift}
\alias{meanshift}
\title{The Meanshift mode estimator}
\usage{
meanshift(x, bw = NULL, kernel = "gaussian", par = shorth(x),
  iter = 1000, tolerance = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{numeric. Vector of observations.}

\item{bw}{numeric. The smoothing bandwidth to be used.}

\item{kernel}{character. The kernel to be used. Available kernels are 
\code{"biweight"}, \code{"cosine"}, \code{"eddy"}, 
\code{"epanechnikov"}, \code{"gaussian"}, \code{"optcosine"}, 
\code{"rectangular"}, \code{"triangular"}, \code{"uniform"}. 
See \code{\link[stats]{density}} for more details on some of these kernels.}

\item{par}{numeric. The initial value used in the meanshift algorithm.}

\item{iter}{numeric. Maximal number of iterations.}

\item{tolerance}{numeric. Stopping criteria.}
}
\value{
\code{meanshift} returns a numeric value, the mode estimate, 
with an attribute \code{"iterations"}. 
The number of iterations can be less than \code{iter} 
if the stopping criteria specified by \code{eps} is reached.
}
\description{
The Meanshift mode estimator.
}
\note{
The user should preferentially call \code{meanshift} through 
\code{mlv(x, method = "meanshift", ...)}.
}
\examples{
# Unimodal distribution
x <- rweibull(100, shape = 12, scale = 0.8)

## True mode
weibullMode(shape = 12, scale = 0.8)

## Estimate of the mode
mlv(x, method = "meanshift", par = mean(x))

}
\references{
\itemize{ 
  \item Fukunaga, K. and Hostetler, L. (1975).  
  The estimation of the gradient of a density function, 
  with applications in pattern recognition. 
  \emph{IEEE Transactions on Information Theory}, \bold{21}(1):32--40. 
}
}
\seealso{
\code{\link[modeest]{mlv}}, \code{\link[modeest]{tsybakov}}.
}
