% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supplement.funct.R
\name{densi.curv.cop}
\alias{densi.curv.cop}
\title{Compute the density of level curves for copulae models}
\usage{
densi.curv.cop(lines, copi, pxf, pyf, u)
}
\arguments{
\item{lines}{location of the objective level curve for which the density needs to be estimated in the 2D space}

\item{copi}{a copula function with the parameters fitted to the bivariate dataset}

\item{pxf}{uniform values of the 1st margin}

\item{pyf}{uniform values of the 1st margin}

\item{u}{original data}
}
\value{
density for each points (couple x,y) along the level curves for copulae
}
\description{
Based on the density function of selected copula
}
\examples{
  \dontrun{
cli<-densi.curv.cop(cli,o,kk[,1],kk[,2],u=u2)
}
}
\seealso{
\code{\link[copula]{dcopula}}
}
