% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.varimp.R
\name{get.varimp}
\alias{get.varimp}
\title{Variable importance scores computed through random forest analysis}
\usage{
get.varimp(rf)
}
\arguments{
\item{rf}{An object of class \code{\linkS4class{mobforest.output}}
returned by \link[=mobforest.analysis]{mobforest.analysis()}}
}
\description{
Variable importance scores computed through random forest analysis
}
\examples{
\dontrun{
library(mlbench)
set.seed(1111)
# Random Forest analysis of model based recursive partitioning load data
data("BostonHousing", package = "mlbench")
BostonHousing <- BostonHousing[1:90, c("rad", "tax", "crim", "medv", "lstat")]

# Recursive partitioning based on linear regression model medv ~ lstat with 3
# trees.  1 core/processor used. 
rfout <- mobforest.analysis(as.formula(medv ~ lstat), c("rad", "tax", "crim"),
    mobforest_controls = mobforest.control(ntree = 3, mtry = 2, replace = TRUE,
        alpha = 0.05, bonferroni = TRUE, minsplit = 25), data = BostonHousing,
    processors = 1, model = linearModel, seed = 1111)
# Returns a vector of variable importance scores
get.varimp(rfout)
}

}
\references{
Leo Breiman (2001). Random Forests. \emph{Machine Learning},
45(1), 5-32.\cr
}
