% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.r2.R
\name{compute.r2}
\alias{compute.r2}
\title{Predictive accuracy estimates across trees for linear or poisson regression}
\usage{
compute.r2(response, predictions)
}
\arguments{
\item{response}{A vector of actual response of outcome variable.}

\item{predictions}{A vector of predictions for the same outcome variable}
}
\value{
Predictive accuracy estimates ranging between 0 and 1.
}
\description{
pseudo R-square (R2) computation - proportion of total variance in response
variable explained by the tree model. The function takes observed and
predicted responses as input arguments and computes pseudo-R2 to determine
how well the tree model fits the given data.
}
\examples{
# This example explains 90\% of the variance
response <- matrix(c(rep(0, 100), rep(10, 100)))
predictions <-
  matrix(nrow = 200, ncol = 3,
         data = c(rep(1, 100), rep(8, 100), rep(1, 100), rep(8, 100),
                  rep(1, 100), rep(8, 100)))
compute.r2(response, predictions)
}
