% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme_curve.R
\name{nlmeCurve}
\alias{nlmeCurve}
\title{NLME fit plotting of MNREAD data.}
\usage{
nlmeCurve(data, print_size, viewing_distance, reading_time, errors, subjectID,
  nested = NULL, group = NULL, CPScriterion = NULL)
}
\arguments{
\item{data}{The name of your dataframe}

\item{print_size}{The variable that contains print size values for each sentence (print size uncorrected for viewing distance)}

\item{viewing_distance}{The variable that contains the viewing distance value used for testing}

\item{reading_time}{The variable that contains the reading time for each sentence}

\item{errors}{The variable that contains the number of errors for each sentence}

\item{subjectID}{The variable that contains the subject identifiers}

\item{nested}{Optional argument to build a model with a nested structure. 'nested' specifies which variable should be nested within subject}

\item{group}{Optional argument to build a model with a grouped structure. 'group' specifies which variable should be used a grouping argument}

\item{CPScriterion}{Optional argument to specify a criterion for CPS estimation. The default criterion value is '90 of MRS'. This criterion can vary from 75 to 95 of MRS and should only be modified for specific purposes, as discussed in Cheung et al. 2008}
}
\value{
The function returns a plot of reading speed (in log words/min) as a function of print size (in logMAR). 
Critical Print Size is marked as an inverted triangle.
}
\description{
This function plots individual MNREAD curves and Critical Print Size (CPS) as estimated by the NLME fit.
}
\section{Notes}{

This function performs print size correction for non-standard testing viewing distance before plotting the curve.

This function uses a nonlinear mixed effects model (NLME), as described in Cheung et al. 2008, to estimate Maximum Reading Speed (MRS) and Critical Print Size (CPS).
For more details on the parameters estimation, see \code{\link{nlmeParam}}.
}

\section{Warning}{

For the function to run properly, one needs to make sure that the variables are of the class:
 \itemize{
  \item \strong{print_size} -> numeric
  \item \strong{viewing_distance} -> integer
  \item \strong{reading_time} -> numeric
  \item \strong{errors} -> integer
  }
}

\examples{
# inspect the structure of the dataframe
head(data_low_vision, 10)

#------

# restrict dataset to one MNREAD test per subject (regular polarity only)
data_regular <- data_low_vision \%>\%
    filter (polarity == "regular")

# plot the NLME fit for data grouped by subject
\dontrun{ nlmeCurve(data_regular, ps, vd, rt, err, subject) }

#------

# plot the NLME fit for the whole dataset with polarity nested within subject
\dontrun{ nlmeCurve(data_low_vision, ps, vd, rt, err, subject,
                    nested = polarity) }

#------

# plot the NLME fit for the whole dataset with polarity nested within subject 
# and grouped based on treatment
\dontrun{ nlmeCurve(data_low_vision, ps, vd, rt, err, subject,
                    nested = polarity, group = treatment) }

#------

# plot the NLME fit for the whole dataset with polarity nested within subject 
# and grouped based on treatment
# for a specific CPS criterion of '80 of MRS'
\dontrun{ nlmeCurve(data_low_vision, ps, vd, rt, err, subject, 
                    nested = polarity, group = treatment, 
                    0.8) }



}
\seealso{
\code{\link{mnreadCurve}} for standard MNREAD curve

\code{\link{curveParam_RT}} for MRS and CPS estimation using values of reading time (instead of reading speed)

\code{\link{readingAcuity}} for Reading Acuity calculation
}
