% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{mnj.pred}
\alias{mnj.pred}
\title{Predict function}
\usage{
mnj.pred(object, X, type = c("response", "prob"), n_tree = NULL)
}
\arguments{
\item{object}{Tree information}

\item{X}{Variable of train data}

\item{type}{Class or probability}

\item{n_tree}{Number of trees}
}
\description{
A custom predict function for FlexBoost
}
\details{
This is a predict function of FlexBoost. FlexBoost consists of two predict functions.
One is built-in function in R and the other is this custom predict function for FlexBoost.
This custom predict function is needed for the calculation of the final strong classifier.
It returns the expected input data's labels.
}
\examples{
data <- read.csv(url("http://bit.ly/flex_iris"), TRUE)
model <- flex(data[,1:2], data[,6], 10, 0.1, 3, 2)
mnj.pred(model, data[,1:2], "response", NULL)
}
