% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_reference.R
\name{ref_address_types}
\alias{ref_address_types}
\alias{ref_answering_bodies}
\alias{ref_areas}
\alias{ref_area_types}
\alias{ref_biography_categories}
\alias{ref_cabinets}
\alias{ref_committees}
\alias{ref_committee_types}
\alias{ref_constituencies}
\alias{ref_constituency_areas}
\alias{ref_constituency_types}
\alias{ref_countries}
\alias{ref_departments}
\alias{ref_disqualification_types}
\alias{ref_elections}
\alias{ref_election_types}
\alias{ref_end_reasons}
\alias{ref_experience_types}
\alias{ref_government_post_departments}
\alias{ref_government_posts}
\alias{ref_government_ranks}
\alias{ref_honourary_prefixes}
\alias{ref_honour_lists}
\alias{ref_honours}
\alias{ref_interest_categories}
\alias{ref_lords_membership_types}
\alias{ref_lords_ranks}
\alias{ref_opposition_post_departments}
\alias{ref_opposition_posts}
\alias{ref_opposition_ranks}
\alias{ref_other_parliaments}
\alias{ref_parliamentary_posts}
\alias{ref_parliamentary_ranks}
\alias{ref_parliament_types}
\alias{ref_parties}
\alias{ref_party_sub_types}
\alias{ref_photo_outputs}
\alias{ref_statuses}
\alias{ref_titles}
\title{Reference data}
\usage{
ref_address_types(tidy = TRUE, tidy_style = "snake_case")

ref_answering_bodies(tidy = TRUE, tidy_style = "snake_case")

ref_areas(tidy = TRUE, tidy_style = "snake_case")

ref_area_types(tidy = TRUE, tidy_style = "snake_case")

ref_biography_categories(tidy = TRUE, tidy_style = "snake_case")

ref_cabinets(tidy = TRUE, tidy_style = "snake_case")

ref_committees(tidy = TRUE, tidy_style = "snake_case")

ref_committee_types(tidy = TRUE, tidy_style = "snake_case")

ref_constituencies(tidy = TRUE, tidy_style = "snake_case")

ref_constituency_areas(tidy = TRUE, tidy_style = "snake_case")

ref_constituency_types(tidy = TRUE, tidy_style = "snake_case")

ref_countries(tidy = TRUE, tidy_style = "snake_case")

ref_departments(tidy = TRUE, tidy_style = "snake_case")

ref_disqualification_types(tidy = TRUE, tidy_style = "snake_case")

ref_elections(tidy = TRUE, tidy_style = "snake_case")

ref_election_types(tidy = TRUE, tidy_style = "snake_case")

ref_end_reasons(tidy = TRUE, tidy_style = "snake_case")

ref_experience_types(tidy = TRUE, tidy_style = "snake_case")

ref_government_post_departments(tidy = TRUE, tidy_style = "snake_case")

ref_government_posts(tidy = TRUE, tidy_style = "snake_case")

ref_government_ranks(tidy = TRUE, tidy_style = "snake_case")

ref_honourary_prefixes(tidy = TRUE, tidy_style = "snake_case")

ref_honour_lists(tidy = TRUE, tidy_style = "snake_case")

ref_honours(tidy = TRUE, tidy_style = "snake_case")

ref_interest_categories(tidy = TRUE, tidy_style = "snake_case")

ref_lords_membership_types(tidy = TRUE, tidy_style = "snake_case")

ref_lords_ranks(tidy = TRUE, tidy_style = "snake_case")

ref_opposition_post_departments(tidy = TRUE, tidy_style = "snake_case")

ref_opposition_posts(tidy = TRUE, tidy_style = "snake_case")

ref_opposition_ranks(tidy = TRUE, tidy_style = "snake_case")

ref_other_parliaments(tidy = TRUE, tidy_style = "snake_case")

ref_parliamentary_posts(tidy = TRUE, tidy_style = "snake_case")

ref_parliamentary_ranks(tidy = TRUE, tidy_style = "snake_case")

ref_parliament_types(tidy = TRUE, tidy_style = "snake_case")

ref_parties(tidy = TRUE, tidy_style = "snake_case")

ref_party_sub_types(tidy = TRUE, tidy_style = "snake_case")

ref_photo_outputs(tidy = TRUE, tidy_style = "snake_case")

ref_statuses(tidy = TRUE, tidy_style = "snake_case")

ref_titles(tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{tidy}{If \code{TRUE}, fixes the variable names in the tibble to
remove non-alphanumeric characters and superfluous text, and convert to
a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy=TRUE}. Accepts one of \code{"snake_case"}, \code{"camelCase"} and
\code{"period.case"}. Defaults to \code{"snake_case"}.}
}
\description{
Reference data on various aspects of parliament. This data is useful for
providing parameters for other function calls. The functions do not accept
any arguments aside from the \code{tidy} and \code{tidy_style} parameters,
which default to \code{TRUE} and \code{'snake_case'}, respectively. To
return all a list with tibbles of all reference data,
see \code{\link[=mnis_all_reference]{mnis_all_reference()}}.
}
\section{\code{mnis_reference} functions}{

\itemize{
\item \code{ref_address_types} The types of addresses available in
member's contact details. Includes websites and social media, as well
as physical addresses
\item \code{ref_answering_bodies} The bodies that members' can address
questions to
\item \code{ref_areas} Geographic areas
\item \code{ref_area_types} Identifiers for grouping areas
(e.g. borough constituencies)
\item \code{ref_biography_categories} Member biography categories
\item \code{ref_cabinets} Connections that a member has to the cabinet or
shadow cabinet
\item \code{ref_committees} Identifier for parliamentary committees
\item \code{ref_committee_types} Types of parliamentary committees
\item \code{ref_constituencies()} All constituencies
\item \code{ref_constituency_areas()} The links between constituencies and
constituency areas
\item \code{ref_constituency_types()} Constituency categories
\item \code{ref_countries()} List of countries that could be listed as
members' birthplace
\item \code{ref_departments()} Government and opposition departments
\item \code{ref_disqualification_types()} Types of ways members can be
disqualified from sitting in the House
\item \code{ref_elections()} Codes of general and by-elections
\item \code{ref_election_types()} Election categories
\item \code{ref_end_reasons()} Reasons a member may leave the House of
Lords or the House of Commons
\item \code{ref_experience_types()} Types of non-parliamentary experience
members can list
\item \code{ref_government_post_departments()} All deparments that can
contain government posts
\item \code{ref_government_posts()} All government posts
\item \code{ref_government_ranks()} All government post ranks
\item \code{ref_honourary_prefixes()} The types of honourary prefixes
for members
\item \code{ref_honour_lists()} The types of honour lists that a member
may be honoured in
\item \code{ref_honours()} The different honours available to members
\item \code{ref_interest_categories()} The categories available for
reporting financial interests
\item \code{ref_lords_membership_types()} Different types of membership
of the House of Lords
\item \code{ref_lords_ranks()} Ranks that peers may hold
\item \code{ref_opposition_post_departments()} The link between opposition
posts and the government department they shadow
\item \code{ref_opposition_posts()} Opposition posts
\item \code{ref_opposition_ranks()} How opposition posts are ranked
\item \code{ref_other_parliaments()} Other parliaments that a member
may have sat in
\item \code{ref_parliamentary_posts()} The different parliamentary posts
available
\item \code{ref_parliamentary_ranks()} How those parliamentary posts are
ranked
\item \code{ref_parliament_types()} Types of parliaments that
parliamentary data may link to
\item \code{ref_parties()} All parties that members can be affiliated with
\item \code{ref_party_sub_types()} Sub-types of parties
\item \code{ref_photo_outputs()} Outputs that a photo of a member
may be linked to
\item \code{ref_statuses()} A member's possible current status in the
House
\item \code{ref_titles()} Salutory titles
}
}

\seealso{
\code{\link[=mnis_all_reference]{mnis_all_reference()}}
}
