% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hypothesentest_funktion_verbessert_2-0Feb2018.R
\name{mmmgee.test}
\alias{mmmgee.test}
\title{Hypothesis Tests for Linear Contrasts in Multiple Marginal GEE Models}
\usage{
mmmgee.test(x, L = NULL, r = NULL, statistic = c("wald", "score"),
  type = c("maximum", "quadratic"), asymptotic = TRUE, biascorr = FALSE,
  closed.test = FALSE, conf.int = FALSE, conf.level = 0.95,
  alternative = c("undirected", "greater", "less"), denomDF = NULL,
  scaled.F = FALSE, tol = 10^(-8), ...)
}
\arguments{
\item{x}{a \code{geem2} object fitted with \code{geem2} or a list of \code{geem2}. In the latter case, the \code{geem2} objects must be different
models calculated with data from the same subjects. In particular, the parameter \code{id} in the call to \code{geem2} must refer to the same subjects in each model.}

\item{L}{a contrast matrix defining a contrast for the stacked vector of regression coefficients of the marginal models, or a list of contrast matrices.
In the latter case, the list must contain one matrix for each model listed in \code{x}, in the same order as the models. When using the the score test \code{x} must it be a list.}

\item{r}{right hand side vector of the null hypothesis or a list of vectors resembling the right hand side of the null hypothesis. If not specified \code{r=0} is assumed. See details.}

\item{statistic}{either \code{"wald"} or \code{"score"}, see details. The default is \code{"wald"}.}

\item{type}{either \code{"maximum"} or \code{"quadratic"}, see details. The default is \code{"maximum"}.}

\item{asymptotic}{logical, if \code{TRUE} the reference distribution for the maximum-type Wald test statistic is a multivariate normal distribution and the reference distribution for 
    the quadratic form Wald test statistic is a chi-squared distribution. If \code{FALSE}, a multivariate t-distribution or an F-distribution is used instead.
Ignored for the Score test, see details.}

\item{biascorr}{logical indicating whether the Mancl and DeRouen Bias correction should be used when estimating the joint covariance matrix via \code{\link{mmmgee}}.}

\item{closed.test}{logical, if \code{TRUE}, multiplicity adjusted p-values based on a closed test procedure using the selected type of test are calculated. With \eqn{k} hypotheses this 
involves the computation of \eqn{2^k} tests, which may require considerable computation time.}

\item{conf.int}{logical. If \code{TRUE} simultaneous confidence intervals corresponding to a single step maximum-type test are calculated using a multivariate
normal or t approximation, depending on \code{asymptotic}.}

\item{conf.level}{the nominal simultaneous coverage probability of the confidence intervals.}

\item{alternative}{one of \code{"undirected"}, \code{"greater"}, or \code{"less"}. Determines the direction of maximum-type tests and of confidence intervals.
The default is \code{"undirected"}.}

\item{denomDF}{Defaults to \code{NULL}. In that case, denominator degrees of freedom for the multavariate t-distribution or F-distribution are calculated as \code{min(n-p)},
where \code{n} and \code{p} are vectors of the number of independent clusters and the number of regression coefficients in the models in \code{x}.
Alternatively, a numeric value may be entered to be used as denominator degrees of freedom.}

\item{scaled.F}{logical. If \code{TRUE} and \code{type="quadratic"} and \code{asymptotic=FALSE} a scaled F distribution similar as for Hotelling's test is used. Ignored otherwise.}

\item{tol}{tolerance limit for the convergence criterion to be passed to \code{\link{geem2}}. Only required when using the score test, where the models are refitted under the
restriction of the null hyptothesis.}

\item{...}{additional arguments that are passed to \code{\link[mvtnorm]{pmvnorm}}, \code{\link[mvtnorm]{qmvnorm}}, \code{\link[mvtnorm]{pmvt}} and \code{\link[mvtnorm]{qmvt}}.
In particular the algorithm to solve the multivariate normal or t-distribution integrals may be selected.}
}
\value{
A list with class \code{mmmgeetest} containing the following components, if required:
\describe{
\item{\code{test}}{Contains a data frame with the test statistic, degrees of freedom (depending in the type of test) and the p-value. If closed test was required,
	a further data frame is reported with estimates, right hand side vector, unadjusted p-values and adjusted p-values for each line of \eqn{H0:L\beta-r=0}.}
\item{\code{hypothesis}}{A list containing the contrast matrix \eqn{L} and the right hand side vector \eqn{r}.}
\item{\code{conf.int}}{The simultaneous confidence intervals.}
\item{\code{denomDF}}{The type and value of the denominator degrees of freedom used in the procedure.}
\item{\code{mmmgee}}{The \code{mmmgee} object containing in particular the estimated covariance matrix for the coefficents of the models in \code{x}. See \code{\link{mmmgee}}.}
}
}
\description{
Global hypothesis tests, multiple testing procedures and simultaneous confidence intervals for multiple linear contrasts of regression
   coefficients in a single generalized estimating equation (GEE) model or across multiple GEE models.
}
\details{
The null hypothesis is \eqn{H0:L\beta=r} where \code{L} is a contrast matrix, \eqn{\beta}
the stacked vector of regression coefficients rom the marginal models and \code{r} a real values right hand side vector.
\code{L} can be specified as matrix or, if it is a block diagonal matrix with each block corresponding to 
a contrast for one marginal GEE model, as list of the matrices on the diagonal. The right hand side \code{r} can be speficied as vector or as list of 
vectors each corresponding to the part of the right hand side vector for one model.

	When choosing \code{statistic="wald"} and \code{type="maximum"}, the maximum of the standardized entries of \eqn{L\hat{\beta}} is used as test statistic and the
p-value is calculated from a multivariate normal or t-distribution (depending on \code{asymptotic} being \code{TRUE} or \code{FALSE}) with correlation matrix
estimated for \eqn{L\hat{\beta}}. For the t-distribution, denominator degrees of freedom are used as specified in \code{denomDF}.
	When choosing \code{statistic="wald"} and \code{type="quadratic"}, a quadratic form of \eqn{L\hat{\beta}} and the inverse of the estimated covariance matrix
of \eqn{L\hat{\beta}} is used as test statistic and the p-value is calculated from a 
chi-squared distribution or an F-distribution (depending on \code{asymptotic} being \code{TRUE} or \code{FALSE}).

With \code{statistic="score"}, generalized score tests are calculated by replacing \eqn{L\hat{\beta}} by the first order approximation \eqn{LAU} where \eqn{U}
is the stacked estimating equation (the score) and \eqn{A} is the negative inverse of the matrix
of first derivatives of \eqn{U}, both evaluated at the location of constrained estimates for \eqn{\beta} under the null hypothesis. 
Analogous to the Wald statistic, a maximum-type and a quadratic form score test are available. For the score test the option \code{asymptotic} is ignored
and the reference distribution is multivariate normal or chi-squared.
}
\note{
Calculating the generalized score test requires refitting the models under the constraint of the null hypothesis.
The function \code{\link[stats]{update}} is used for this task. It will use the function calls as stated in the slot \code{call} of the \code{geem2} objects.
There is one important point to notice: The function \code{update} will first look for any components of the fitted object in the environment from which it was
called, which is an internal function of the package.
Within this internal function the variables 'Modelle', 'L.list', 'r.list', 'tol', 'type', 'alternative' and 'biascorr' are used. If any component of the model
object happens to have one of these names, (e.g. if your data frame is called 'tol'), \code{update} will erronously try to use the internal object of that name.

A single value for the denominator degrees of freedom is calculated for the covariance matrix estiamate across all contrasts. In the close testing procedure,
  	this value is used for the degrees of freedom
associated with the covariance matrix of any subset of contrasts.

Usual linear models or generalized linear models can be regarded as special case of GEE models and can be included in the analysis framework.
}
\examples{
data(lesions)
m1<-geem2(clearance~trt,id=id,data=lesions,family=binomial,corstr="independence")
m2<-geem2(pain~trt,id=id,data=lesions[lesions$lesion==1,],family=gaussian,corstr="independence")
L1<-L2<-diag(1,4)[-1,]
mmmgee.test(x=m1,L=list(L1),statistic="wald",type="maximum")
mmmgee.test(x=m1,L=list(L1),statistic="score",type="maximum")
mmmgee.test(x=list(m1,m2),L=list(L1,L2),type="maximum",asymptotic=FALSE,biascorr=TRUE)
mmmgee.test(x=list(m1,m2),L=list(L1,L2),type="maximum",closed.test=TRUE)
mmmgee.test(x=list(m1,m2),L=list(L1,L2),type="maximum",asymptotic=FALSE,
	alternative="less",conf.int=TRUE,denomDF=40)
mmmgee.test(x=list(m1,m2),L=list(L1,L2),type="quadratic",asymptotic=TRUE)
mmmgee.test(x=list(m1,m2),L=list(L1,L2),statistic="score",type="quadratic")
mmmgee.test(x=list(m1,m2),L=list(L1,L2),statistic="score",type="maximum")

}
\references{
Dennis D. Boos. On generalized score tests. The American Statistician, 1992, 46(4):327-333.

Lloyd A. Mancl, Timothy A. DeRouen. A covariance estimator for GEE with improved small sample properties. Biometrics, 2001, 57(1):126-134.
}
\seealso{
\code{\link{geem2}}, \code{\link{mmmgee}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}
}
