% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sPhikf}
\alias{sPhikf}
\title{Fisher information matrix and score vectors of the variance components for Model 1}
\usage{
sPhikf(pp, sigmap, X, eta, phi)
}
\arguments{
\item{pp}{vector with the number of the auxiliary variables per category.}

\item{sigmap}{a list with the model variance-covariance matrices for each domain obtained from \code{\link[mme]{wmatrix}}.}

\item{X}{list of matrices with the auxiliary variables obtained from \code{\link[mme]{data.mme}}. The dimension of the list is the number of categories of the response variable minus one.}

\item{eta}{matrix with the estimated log-rates of probabilities of each category over the reference category obtained from
\code{\link[mme]{prmu}}.}

\item{phi}{vector with the values of the variance components obtained from \code{\link[mme]{modelfit1}}.}
}
\value{
A list containing the following components.
\item{S.k}{phi score vector.}
\item{F}{Fisher information matrix of the variance component phi.}
}
\description{
This function computes the Fisher information matrix and the score vectors
of the variance components, for the multinomial mixed model with
one independent random effect in each category
of the response variable (Model 1). These values are used in the fitting algorithm
implemented in \code{\link[mme]{modelfit1}} to estimate the random effects. The algorithm adatps the ideas of Schall (1991) to a multivariate
model. The variance components are estimated by the REML method.
}
\examples{
k=3 #number of categories of the response variable
pp=c(1,1) #vector with the number of auxiliary variables in each category
data(simdata) #data
mod=1 #type of model
datar=data.mme(simdata,k,pp, mod)
initial=datar$initial
mean=prmu(datar$n,datar$Xk,initial$beta.0,initial$u.0)
sigmap=wmatrix(datar$n,mean$estimated.probabilities)

##Fisher information matrix and score vectors
Fisher.phi=sPhikf(pp,sigmap,datar$X,mean$eta,initial$phi.0)
}
\references{
Lopez-Vizcaino, ME, Lombardia, MJ and Morales, D (2013).
Multinomial-based small area estimation of labour force indicators.
Statistical Modelling, 13 ,153-178.

Schall, R (1991). Estimation in generalized linear models with
random effects. Biometrika,
78,719-727.
}
\seealso{
\code{\link[mme]{data.mme}}, \code{\link[mme]{initial.values}},
\code{\link[mme]{wmatrix}}, \code{\link[mme]{phi.mult}},
\code{\link[mme]{prmu}}, \code{\link[mme]{phi.direct}},
\code{\link[mme]{Fbetaf}}, \code{\link[mme]{ci}},
\code{\link[mme]{modelfit1}}, \code{\link[mme]{msef}},
\code{\link[mme]{mseb}}.
}
\keyword{models}

