% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometric_weight.R
\name{geometric_weight}
\alias{geometric_weight}
\title{Geometric Weight}
\usage{
geometric_weight(k, n, r = 1)
}
\arguments{
\item{k}{r^k/sum(r^(1, 2, ... n))}

\item{n}{r^k/sum(r^(1, 2, ... n))}

\item{r}{r^k/sum(r^(1, 2, ... n))}
}
\description{
Generate geometric weights
}
\details{
Returns a weight based on the formula r^k/sum(r^seq_len(n)). The sequence of weights for k=1, 2, ..., n sum to 1
}
\examples{
geometric_weight(1:3, n=3, r=1)
geometric_weight(1:3, n=3, r=.5)
geometric_weight(1:3, n=3, r=2)

}
