% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_factor.R
\name{date_factor}
\alias{date_factor}
\title{Date Factor}
\usage{
date_factor(dateVec, type = "yearmonth", minDate = min(dateVec, na.rm =
  TRUE), maxDate = max(dateVec, na.rm = TRUE))
}
\arguments{
\item{dateVec}{A vector of date values}

\item{type}{One of {"year", "yearquarter", "yearmonth", "quarter", "month"}}

\item{minDate}{(Default = min(dateVec)) When determining factor levels, use this date to set the min level, after coercing 
dates to the specified \code{type}. For example, if dateVec = (2016-01-15, 2016-02-15), type = "yearmonth", and minDate = 2016-02-01,
the result will be (NA, Feb 2016).}

\item{maxDate}{(Default = max(dateVec)) When determining factor levels, use this date to set the max level. (See minDate, above)}
}
\description{
Map a vector of dates to a factor at one of these levels {"yearmonth", "yearquarter", "quarter", "month"}
}
\details{
The resulting vector is an ordered factor of the specified \code{type} (e.g. yearmonth)
}
\examples{
library(data.table)
dts <- as.Date(c("2014-1-1", "2015-1-15", "2015-6-1"))
date_factor(dts, type = "yearmonth")
date_factor(dts, type = "yearquarter")
date_factor(
  dateVec = dts, 
  type = "yearquarter", 
  minDate = as.Date("2015-1-1"), 
  maxDate = as.Date("2015-12-31")
)
date_factor(
  dateVec = as.Date(character(0)), 
  type = "yearmonth", 
  minDate = as.Date("2016-1-1"), 
  as.Date("2016-12-31")
)

}
