% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doublecaret.R
\name{\%>>\%}
\alias{\%>>\%}
\alias{\%<<\%}
\alias{\%<>>\%}
\alias{\%<<<\%}
\alias{\%>|\%}
\alias{\%|<\%}
\title{CPO Composition / Attachment / Application Operator}
\usage{
cpo1 \%>>\% cpo2

cpo2 \%<<\% cpo1

cpo1 \%<>>\% cpo2

cpo2 \%<<<\% cpo1

cpo1 \%>|\% cpo2

cpo2 \%|<\% cpo1
}
\arguments{
\item{cpo1}{[\code{\link[base]{data.frame}} | \code{\link[mlr]{Task}} | \code{\link{CPO}} | \code{\link{CPOTrained}}]\cr
The source object.}

\item{cpo2}{[\code{\link{CPO}} | \code{\link{CPOTrained}} | \code{\link[mlr:makeLearner]{Learner}}]\cr
The sink object.}
}
\value{
[\code{\link[base]{data.frame}} | \code{\link[mlr]{Task}} | \code{\link{CPO}} | \code{\link{CPOTrained}}].
}
\description{
This operator \dQuote{pipes} data from the source into the sink object.

If both objects are a \code{\link{CPO}} object, or both are a \code{\link{CPOTrained}} object,
they will be composed. A new object, representing the operation of performing both object's operations in succession,
will be created, which can be handled like a new CPO or CPOTrained object. See \code{\link{composeCPO}}.

If the source object is a \code{\link[base]{data.frame}} or a \code{link[mlr]{Task}}, the
transformation operation will be applied to this data, and the same resulting
data will be returned. See \code{\link{applyCPO}}.

If the sink object is a \code{\link[mlr:makeLearner]{Learner}}, the CPO will be attached to
this learner. The same operation will be performed during the \code{\link[mlr]{train}} and
\code{\link[stats]{predict}} phase; the behaviour during the predict phase may furthermore
be depend on the training data. See \code{\link{attachCPO}}.

Note that you can not link a \code{data.frame} or \code{\link[mlr]{Task}} directly
to a \code{\link[mlr:makeLearner]{Learner}}, since this operation is not algebraically associative
with the composition of CPOs. Use \code{\link[mlr]{train}} for this.

The \code{\%<<\%} operator is synonymous with \code{\%>>\%} with source and sink argument swapped.

The \code{\%>|\%} and \code{\%|<\%} operators perform piping followed by application of \code{\link{retrafo}}.
The \code{\%>|\%} evaluates the expression to its right before the expression to its left, so it may be
used in the most natural way without parentheses:

\code{data \%>|\% cpo1 \%>>\% cpo2}

is the same as

\code{retrafo(data \%>>\% cpo1 \%>>\% cpo2)}.


The \code{\%<>>\%} and \code{\%<<<\%} operators perform the piping operation and assign the result
to the left hand variable. This way it is possible to apply a \code{\link{CPO}}, or to
attach a \code{\link{CPO}} to a \code{\link[mlr:makeLearner]{Learner}}, and just keep the resulting
object. The assignment operators evaluate their right hand side before their left hand side, so
it is possible to build long chains that end up writing to the leftmost variable. Therefore the expression

\code{data \%<>>\% cpo1 \%<>>\% cpo2 \%>>\% cpo3}

is the same as

\preformatted{cpo1 = cpo1 \%>>\% cpo2 \%>>\% cpo3
data = data \%>>\% cpo1}
}
\examples{
# PCA-rotate pid.task
rotated.pid.task = pid.task \%>>\% cpoScale() \%>>\% cpoPca()

# Centering / Scaling *after* PCA
newPCA = cpoPca() \%>>\% cpoScale()

# Attach the above to learner
pcaLogreg = newPCA \%>>\% makeLearner("classif.logreg")

# append cpoAsNumeric to newPCA
newPCA \%<>>\% cpoAsNumeric()
print(newPCA)

# prepend cpoAsNumeric to pcaLogreg
pcaLogreg \%<<<\% cpoAsNumeric()

}
\seealso{
Other operators: 
\code{\link{CPO}},
\code{\link{applyCPO}()},
\code{\link{as.list.CPO}},
\code{\link{attachCPO}()},
\code{\link{composeCPO}()},
\code{\link{pipeCPO}()}

Other retrafo related: 
\code{\link{CPOTrained}},
\code{\link{NULLCPO}},
\code{\link{applyCPO}()},
\code{\link{as.list.CPO}},
\code{\link{clearRI}()},
\code{\link{getCPOClass}()},
\code{\link{getCPOName}()},
\code{\link{getCPOOperatingType}()},
\code{\link{getCPOPredictType}()},
\code{\link{getCPOProperties}()},
\code{\link{getCPOTrainedCPO}()},
\code{\link{getCPOTrainedCapability}()},
\code{\link{getCPOTrainedState}()},
\code{\link{is.retrafo}()},
\code{\link{makeCPOTrainedFromState}()},
\code{\link{pipeCPO}()},
\code{\link{print.CPOConstructor}()}

Other inverter related: 
\code{\link{CPOTrained}},
\code{\link{NULLCPO}},
\code{\link{applyCPO}()},
\code{\link{as.list.CPO}},
\code{\link{clearRI}()},
\code{\link{getCPOClass}()},
\code{\link{getCPOName}()},
\code{\link{getCPOOperatingType}()},
\code{\link{getCPOPredictType}()},
\code{\link{getCPOProperties}()},
\code{\link{getCPOTrainedCPO}()},
\code{\link{getCPOTrainedCapability}()},
\code{\link{getCPOTrainedState}()},
\code{\link{is.inverter}()},
\code{\link{makeCPOTrainedFromState}()},
\code{\link{pipeCPO}()},
\code{\link{print.CPOConstructor}()}

Other CPO lifecycle related: 
\code{\link{CPOConstructor}},
\code{\link{CPOLearner}},
\code{\link{CPOTrained}},
\code{\link{CPO}},
\code{\link{NULLCPO}},
\code{\link{attachCPO}()},
\code{\link{composeCPO}()},
\code{\link{getCPOClass}()},
\code{\link{getCPOConstructor}()},
\code{\link{getCPOTrainedCPO}()},
\code{\link{identicalCPO}()},
\code{\link{makeCPO}()}
}
\concept{CPO lifecycle related}
\concept{inverter related}
\concept{operators}
\concept{retrafo related}
