% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskRegr.R
\name{autoplot.TaskRegr}
\alias{autoplot.TaskRegr}
\title{Plot for Regression Tasks}
\usage{
\method{autoplot}{TaskRegr}(object, type = "target", ...)
}
\arguments{
\item{object}{(\link[mlr3:TaskRegr]{mlr3::TaskRegr}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{...}{(\code{any}):
Additional argument, passed down to the underlying \code{geom} or plot
functions.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[mlr3:TaskRegr]{mlr3::TaskRegr}, depending on argument \code{type}:
\itemize{
\item \code{"target"}: Box plot of target variable (default).
\item \code{"pairs"}: Passes data and additional arguments down to
\code{\link[GGally:ggpairs]{GGally::ggpairs()}}. Color is set to target column.
}
}
\section{Theme}{

The \code{\link[=theme_mlr3]{theme_mlr3()}} and viridis color maps are applied by default to all
\code{autoplot()} methods. To change this behavior set
\code{options(mlr3.theme = FALSE)}.
}

\examples{
if (requireNamespace("mlr3")) {
  library(mlr3)
  library(mlr3viz)

  task = tsk("mtcars")
  task$select(c("am", "carb"))

  head(fortify(task))
  autoplot(task)
  autoplot(task, type = "pairs")
}
}
