% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionClassif.R
\name{autoplot.PredictionClassif}
\alias{autoplot.PredictionClassif}
\title{Plot for PredictionClassif}
\usage{
\method{autoplot}{PredictionClassif}(object, type = "stacked", measure = NULL, ...)
}
\arguments{
\item{object}{(\link[mlr3:PredictionClassif]{mlr3::PredictionClassif}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{measure}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Performance measure to use.}

\item{...}{(\code{any}):
Additional arguments, passed down to the respective \code{geom}, plotting function or measure.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[mlr3:PredictionClassif]{mlr3::PredictionClassif}, depending on argument \code{type}:
\itemize{
\item \code{"stacked"} (default): Stacked barplot of true and estimated class labels.
\item \code{"roc"}: ROC curve (1 - specificity on x, sensitivity on y).
Requires package \CRANpkg{precrec}.
\item \code{"prc"}: Precision recall curve.
Requires package \CRANpkg{precrec}.
\item \code{"threshold"}: Systematically varies the threshold of the \link[mlr3:PredictionClassif]{mlr3::PredictionClassif}
object and plots the resulting performance as returned by \code{measure}.
Arguments in \code{...} are passed down to the score function of the \link[mlr3:Measure]{mlr3::Measure}.
}
}
\section{Theme}{

The \code{\link[=theme_mlr3]{theme_mlr3()}} and viridis color maps are applied by default to all
\code{autoplot()} methods. To change this behavior set
\code{options(mlr3.theme = FALSE)}.
}

\examples{
if (requireNamespace("mlr3")) {
  library(mlr3)
  library(mlr3viz)

  task = tsk("spam")
  learner = lrn("classif.rpart", predict_type = "prob")
  object = learner$train(task)$predict(task)

  head(fortify(object))
  autoplot(object)
  autoplot(object, type = "roc")
  autoplot(object, type = "prc")
}
}
\references{
Saito T, Rehmsmeier M (2017).
\dQuote{Precrec: fast and accurate precision-recall and ROC curve calculations in R.}
\emph{Bioinformatics}, \bold{33}(1), 145-147.
\doi{10.1093/bioinformatics/btw570}.
}
