% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskSurv.R
\name{autoplot.TaskSurv}
\alias{autoplot.TaskSurv}
\title{Plot for Survival Tasks}
\usage{
\method{autoplot}{TaskSurv}(object, type = "target", ...)
}
\arguments{
\item{object}{(\link[mlr3proba:TaskSurv]{mlr3proba::TaskSurv}).}

\item{type}{(\code{character(1)}):\cr
Type of the plot. Available choices:}

\item{...}{(\code{any}):
Additional argument, passed down to \verb{$formula} of \link[mlr3proba:TaskSurv]{mlr3proba::TaskSurv} or the underlying plot functions.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[mlr3proba:TaskSurv]{mlr3proba::TaskSurv}, depending on argument \code{type}:
\itemize{
\item \code{"target"}: Calls \code{\link[GGally:ggsurv]{GGally::ggsurv()}} on a \code{\link[survival:survfit]{survival::survfit()}} object.
\item \code{"duo"}: Passes data and additional arguments down to \code{\link[GGally:ggduo]{GGally::ggduo()}}.
\code{columnsX} is target, \code{columnsY} is features.
\item \code{"pairs"}: Passes data and additional arguments down to \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Color is set to target column.
}
}
\examples{
library(mlr3)
library(mlr3viz)
library(mlr3proba)

task = mlr_tasks$get("lung")

head(fortify(task))
autoplot(task)
autoplot(task, rhs = "sex")
}
