% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TuningSpace.R
\name{TuningSpace}
\alias{TuningSpace}
\title{Tuning Spaces}
\description{
This class defines a tuning space for hyperparameter tuning.

For tuning, it is important to create a search space that defines the range over which hyperparameters should be tuned.
\code{TuningSpace} object consists of search spaces from peer-reviewed articles which work well for a wide range of data sets.

The \verb{$values} field stores a list of \link[paradox:to_tune]{paradox::TuneToken} which define the search space.
These tokens can be assigned to the \verb{$values} slot of a learner's \link[paradox:ParamSet]{paradox::ParamSet}.
When the learner is tuned, the tokens are used to create the search space.
}
\section{S3 Methods}{

\itemize{
\item \code{as.data.table.TuningSpace(x)}\cr
Returns a tabular view of the tuning space.\cr
\link{TuningSpace} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
\itemize{
\item \code{x} (\link{TuningSpace})
}
}
}

\examples{
library(mlr3tuning)

# get default tuning space of rpart learner
tuning_space = lts("classif.rpart.default")

# get learner and set tuning space
learner = lrn("classif.rpart")
learner$param_set$values = tuning_space$values

# tune learner
instance = tune(
 tnr("random_search"),
 task = tsk("pima"),
 learner = learner,
 resampling = rsmp ("holdout"),
 measure = msr("classif.ce"),
 term_evals = 10)

instance$result
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the object.}

\item{\code{values}}{(\code{list()})\cr
List of \link[paradox:to_tune]{paradox::TuneToken} that describe the tuning space and fixed parameter values.}

\item{\code{tags}}{(\code{character()})\cr
Arbitrary tags to group and filter tuning space e.g. \code{"classification"} or "\code{regression}".}

\item{\code{learner}}{(\code{character(1)})\cr
\link[mlr3:Learner]{mlr3::Learner} of the tuning space.}

\item{\code{package}}{(\code{character(1)})\cr
Packages which provide the \link[mlr3:Learner]{mlr3::Learner}, e.g. \CRANpkg{mlr3learners} for the learner
\link[mlr3learners:mlr_learners_classif.ranger]{mlr3learners::LearnerClassifRanger} which interfaces the \CRANpkg{ranger} package.}

\item{\code{label}}{(\code{character(1)})\cr
Label for this object.
Can be used in tables, plot and text output instead of the ID.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TuningSpace-new}{\code{TuningSpace$new()}}
\item \href{#method-TuningSpace-get_learner}{\code{TuningSpace$get_learner()}}
\item \href{#method-TuningSpace-format}{\code{TuningSpace$format()}}
\item \href{#method-TuningSpace-help}{\code{TuningSpace$help()}}
\item \href{#method-TuningSpace-print}{\code{TuningSpace$print()}}
\item \href{#method-TuningSpace-clone}{\code{TuningSpace$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TuningSpace-new"></a>}}
\if{latex}{\out{\hypertarget{method-TuningSpace-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TuningSpace$new(
  id,
  values,
  tags,
  learner,
  package = character(),
  label = NA_character_,
  man = NA_character_
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{\code{values}}{(\code{list()})\cr
List of \link[paradox:to_tune]{paradox::TuneToken} that describe the tuning space and fixed parameter values.}

\item{\code{tags}}{(\code{character()})\cr
Tags to group and filter tuning spaces e.g. \code{"classification"} or "\code{regression}".}

\item{\code{learner}}{(\code{character(1)})\cr
\link[mlr3:Learner]{mlr3::Learner} of the tuning space.}

\item{\code{package}}{(\code{character()})\cr
Packages which provide the \link[mlr3:Learner]{mlr3::Learner}, e.g. \CRANpkg{mlr3learners} for the learner
\link[mlr3learners:mlr_learners_classif.ranger]{mlr3learners::LearnerClassifRanger} which interfaces the \CRANpkg{ranger} package.}

\item{\code{label}}{(\code{character(1)})\cr
Label for the new instance.
Can be used in tables, plot and text output instead of the ID.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for for the new instance.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TuningSpace-get_learner"></a>}}
\if{latex}{\out{\hypertarget{method-TuningSpace-get_learner}{}}}
\subsection{Method \code{get_learner()}}{
Returns a learner with \link[paradox:to_tune]{paradox::TuneToken} set in parameter set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TuningSpace$get_learner(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(named ‘list()’)\cr
Passed to \code{mlr3::lrn()}. Named arguments passed to the constructor, to
be set as parameters in the \link[paradox:ParamSet]{paradox::ParamSet}, or to be set as public
field. See \code{mlr3misc::dictionary_sugar_get()} for more details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[mlr3:Learner]{mlr3::Learner}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TuningSpace-format"></a>}}
\if{latex}{\out{\hypertarget{method-TuningSpace-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TuningSpace$format(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TuningSpace-help"></a>}}
\if{latex}{\out{\hypertarget{method-TuningSpace-help}{}}}
\subsection{Method \code{help()}}{
Opens the corresponding help page referenced by field \verb{$man}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TuningSpace$help()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TuningSpace-print"></a>}}
\if{latex}{\out{\hypertarget{method-TuningSpace-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TuningSpace$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TuningSpace-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TuningSpace-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TuningSpace$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
