% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContextBatchTuning.R
\name{ContextBatchTuning}
\alias{ContextBatchTuning}
\title{Batch Tuning Context}
\description{
A \link{CallbackBatchTuning} accesses and modifies data during the optimization via the \code{ContextBatchTuning}.
See the section on active bindings for a list of modifiable objects.
See \code{\link[=callback_batch_tuning]{callback_batch_tuning()}} for a list of stages that access \code{ContextBatchTuning}.
}
\section{Super classes}{
\code{\link[mlr3misc:Context]{mlr3misc::Context}} -> \code{\link[bbotk:ContextBatch]{bbotk::ContextBatch}} -> \code{ContextBatchTuning}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{xss}}{(list())\cr
The hyperparameter configurations of the latest batch.
Contains the values on the learner scale i.e. transformations are applied.
See \verb{$xdt} for the untransformed values.}

\item{\code{design}}{(\link[data.table:data.table]{data.table::data.table})\cr
The benchmark design of the latest batch.}

\item{\code{benchmark_result}}{(\link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult})\cr
The benchmark result of the latest batch.}

\item{\code{aggregated_performance}}{(\link[data.table:data.table]{data.table::data.table})\cr
Aggregated performance scores and training time of the latest batch.
This data table is passed to the archive.
A callback can add additional columns which are also written to the archive.}

\item{\code{result_learner_param_vals}}{(list())\cr
The learner parameter values passed to \code{instance$assign_result()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ContextBatchTuning-clone}{\code{ContextBatchTuning$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Context" data-id="format"><a href='../../mlr3misc/html/Context.html#method-Context-format'><code>mlr3misc::Context$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Context" data-id="print"><a href='../../mlr3misc/html/Context.html#method-Context-print'><code>mlr3misc::Context$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ContextBatch" data-id="initialize"><a href='../../bbotk/html/ContextBatch.html#method-ContextBatch-initialize'><code>bbotk::ContextBatch$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContextBatchTuning-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ContextBatchTuning-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContextBatchTuning$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
