% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoTuner.R
\name{AutoTuner}
\alias{AutoTuner}
\title{AutoTuner}
\description{
The \code{AutoTuner} is a \link[mlr3:Learner]{mlr3::Learner} which wraps another \link[mlr3:Learner]{mlr3::Learner}
and performs the following steps during \verb{$train()}:
\enumerate{
\item The hyperparameters of the wrapped (inner) learner are trained on the
training data via resampling.
The tuning can be specified by providing a \link{Tuner}, a \link[bbotk:Terminator]{bbotk::Terminator},
a search space as \link[paradox:ParamSet]{paradox::ParamSet}, a \link[mlr3:Resampling]{mlr3::Resampling} and a
\link[mlr3:Measure]{mlr3::Measure}.
\item The best found hyperparameter configuration is set as hyperparameters
for the wrapped (inner) learner.
\item A final model is fit on the complete training data using the now
parametrized wrapped learner.
}

During \verb{$predict()} the \code{AutoTuner} just calls the predict method of the
wrapped (inner) learner.

Note that this approach allows to perform nested resampling by passing an
\link{AutoTuner} object to \code{\link[mlr3:resample]{mlr3::resample()}} or \code{\link[mlr3:benchmark]{mlr3::benchmark()}}.
To access the inner resampling results, set \code{store_tuning_instance = TRUE}
and execute \code{\link[mlr3:resample]{mlr3::resample()}} or \code{\link[mlr3:benchmark]{mlr3::benchmark()}} with
\code{store_models = TRUE} (see examples).
}
\examples{
library(mlr3)
library(paradox)

task = tsk("iris")
search_space = ParamSet$new(
  params = list(ParamDbl$new("cp", lower = 0.001, upper = 0.1))
)

at = AutoTuner$new(
  learner = lrn("classif.rpart"),
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  terminator = trm("evals", n_evals = 5),
  tuner = tnr("grid_search"),
  search_space = search_space,
  store_tuning_instance = TRUE)

at$train(task)
at$model
at$learner

# Nested resampling
at = AutoTuner$new(
  learner = lrn("classif.rpart"),
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  terminator = trm("evals", n_evals = 5),
  tuner = tnr("grid_search"),
  search_space = search_space,
  store_tuning_instance = TRUE)

resampling_outer = rsmp("cv", folds = 2)
rr = resample(task, at, resampling_outer, store_models = TRUE)

# Aggregate performance of outer results
rr$aggregate()

# Retrieve inner tuning results.
as.data.table(rr)$learner[[1]]$tuning_result
}
\section{Super class}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{AutoTuner}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{instance_args}}{(\code{list()})\cr
All arguments from construction to create the \link{TuningInstanceSingleCrit}.}

\item{\code{tuner}}{(\link{Tuner}).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{archive}}{\link{ArchiveTuning}\cr
Archive of the \link{TuningInstanceSingleCrit}.}

\item{\code{learner}}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Trained learner}

\item{\code{tuning_instance}}{(\link{TuningInstanceSingleCrit})\cr
Internally created tuning instance with all intermediate results.}

\item{\code{tuning_result}}{(named \code{list()})\cr
Short-cut to \code{result} from \link{TuningInstanceSingleCrit}.}

\item{\code{predict_type}}{(\code{character(1)})\cr
Stores the currently active predict type, e.g. \code{"response"}.
Must be an element of \verb{$predict_types}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AutoTuner$new()}}
\item \href{#method-clone}{\code{AutoTuner$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format">}\href{../../mlr3/html/Learner.html#method-format}{\code{mlr3::Learner$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help">}\href{../../mlr3/html/Learner.html#method-help}{\code{mlr3::Learner$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="is_retrainable">}\href{../../mlr3/html/Learner.html#method-is_retrainable}{\code{mlr3::Learner$is_retrainable()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict">}\href{../../mlr3/html/Learner.html#method-predict}{\code{mlr3::Learner$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata">}\href{../../mlr3/html/Learner.html#method-predict_newdata}{\code{mlr3::Learner$predict_newdata()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print">}\href{../../mlr3/html/Learner.html#method-print}{\code{mlr3::Learner$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset">}\href{../../mlr3/html/Learner.html#method-reset}{\code{mlr3::Learner$reset()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="retrain">}\href{../../mlr3/html/Learner.html#method-retrain}{\code{mlr3::Learner$retrain()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train">}\href{../../mlr3/html/Learner.html#method-train}{\code{mlr3::Learner$train()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="update">}\href{../../mlr3/html/Learner.html#method-update}{\code{mlr3::Learner$update()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutoTuner$new(
  learner,
  resampling,
  measure,
  terminator,
  tuner,
  search_space = NULL,
  store_tuning_instance = TRUE,
  store_benchmark_result = TRUE,
  store_models = FALSE,
  check_values = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learner}}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Learner to tune, see \link{TuningInstanceSingleCrit}.}

\item{\code{resampling}}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Resampling strategy during tuning, see \link{TuningInstanceSingleCrit}. This
\link[mlr3:Resampling]{mlr3::Resampling} is meant to be the \strong{inner} resampling, operating
on the training set of an arbitrary outer resampling. For this reason
it is not feasible to pass an instantiated \link[mlr3:Resampling]{mlr3::Resampling} here.}

\item{\code{measure}}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Performance measure to optimize.}

\item{\code{terminator}}{(\link[bbotk:Terminator]{bbotk::Terminator})\cr
When to stop tuning, see \link{TuningInstanceSingleCrit}.}

\item{\code{tuner}}{(\link{Tuner})\cr
Tuning algorithm to run.}

\item{\code{search_space}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Hyperparameter search space, see \link{TuningInstanceSingleCrit}.}

\item{\code{store_tuning_instance}}{(\code{logical(1)})\cr
If \code{TRUE} (default), stores the internally created
\link{TuningInstanceSingleCrit} with all intermediate results in slot
\verb{$tuning_instance}.}

\item{\code{store_benchmark_result}}{(\code{logical(1)})\cr
If \code{TRUE} (default), stores the \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult} in archive.}

\item{\code{store_models}}{(\code{logical(1)})\cr
If \code{FALSE} (default), the fitted models are not stored in the
\link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}. If \code{store_benchmark_result = FALSE}, the models are
only stored temporarily and not accessible after the tuning. This combination
might be useful for measures that require a model.}

\item{\code{check_values}}{(\code{logical(1)})\cr
Should parameters before the evaluation and the results be checked for
validity?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutoTuner$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
