% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerNLoptr.R
\name{mlr_tuners_nloptr}
\alias{mlr_tuners_nloptr}
\alias{TunerNLoptr}
\title{TuneNLoptr}
\source{
\cite{bbotk}{johnson_2014}
}
\description{
\code{TunerNLoptr} class that implements non-linear optimization. Calls
\link[nloptr:nloptr]{nloptr::nloptr} from package \CRANpkg{nloptr}.
}
\details{
The termination conditions \code{stopval}, \code{maxtime} and \code{maxeval} of
\code{\link[nloptr:nloptr]{nloptr::nloptr()}} are deactivated and replaced by the \link[bbotk:Terminator]{bbotk::Terminator}
subclasses. The x and function value tolerance termination conditions
(\code{xtol_rel = 10^-4}, \code{xtol_abs = rep(0.0, length(x0))},
\code{ftol_rel = 0.0} and \code{ftol_abs = 0.0}) are still available and implemented with
their package defaults. To deactivate these conditions, set them to \code{-1}.
}
\section{Dictionary}{

This \link{Tuner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_tuners} or with the associated sugar function \code{\link[=tnr]{tnr()}}:\preformatted{mlr_tuners$get("nloptr")
tnr("nloptr")
}
}

\section{Logging}{


All \link{Tuner}s use a logger (as implemented in \CRANpkg{lgr}) from package
\CRANpkg{bbotk}.
Use \code{lgr::get_logger("bbotk")} to access and control the logger.
}

\section{Parameters}{


\describe{
\item{\code{algorithm}}{\code{character(1)}}
\item{\code{x0}}{\code{numeric()}}
\item{\code{eval_g_ineq}}{\verb{function()}}
\item{\code{xtol_rel}}{\code{numeric(1)}}
\item{\code{xtol_abs}}{\code{numeric(1)}}
\item{\code{ftol_rel}}{\code{numeric(1)}}
\item{\code{ftol_abs}}{\code{numeric(1)}}
}

For the meaning of the control parameters, see \code{\link[nloptr:nloptr]{nloptr::nloptr()}} and
\code{\link[nloptr:nloptr.print.options]{nloptr::nloptr.print.options()}}.

The termination conditions \code{stopval}, \code{maxtime} and \code{maxeval} of
\code{\link[nloptr:nloptr]{nloptr::nloptr()}} are deactivated and replaced by the \link[bbotk]{Terminator}
subclasses. The x and function value tolerance termination conditions
(\code{xtol_rel = 10^-4}, \code{xtol_abs = rep(0.0, length(x0))}, \code{ftol_rel = 0.0} and
\code{ftol_abs = 0.0}) are still available and implemented with their package
defaults. To deactivate these conditions, set them to \code{-1}.

}

\examples{
\dontrun{
library(mlr3)
library(paradox)
library(data.table)
search_space = ParamSet$new(list(
  ParamDbl$new("cp", lower = 0.001, upper = 0.1)
))
# We use the internal termination criterion xtol_rel
terminator = trm("none")
instance = TuningInstanceSingleCrit$new(
  task = tsk("iris"),
  learner = lrn("classif.rpart"),
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  search_space = search_space,
  terminator = terminator
)
tt = tnr("nloptr", x0 = 0.1, algorithm = "NLOPT_LN_BOBYQA")
# modifies the instance by reference
tt$optimize(instance)
# returns best configuration and best performance
instance$result
# allows access of data.table of full path of all evaluations
instance$archive
}
}
\section{Super classes}{
\code{\link[mlr3tuning:Tuner]{mlr3tuning::Tuner}} -> \code{\link[mlr3tuning:TunerFromOptimizer]{mlr3tuning::TunerFromOptimizer}} -> \code{TunerNLoptr}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TunerNLoptr$new()}}
\item \href{#method-clone}{\code{TunerNLoptr$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="format">}\href{../../mlr3tuning/html/Tuner.html#method-format}{\code{mlr3tuning::Tuner$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="print">}\href{../../mlr3tuning/html/Tuner.html#method-print}{\code{mlr3tuning::Tuner$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3tuning" data-topic="TunerFromOptimizer" data-id="optimize">}\href{../../mlr3tuning/html/TunerFromOptimizer.html#method-optimize}{\code{mlr3tuning::TunerFromOptimizer$optimize()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerNLoptr$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerNLoptr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
