% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{ti}
\alias{ti}
\title{Syntactic Sugar for Object Construction}
\usage{
ti(
  task,
  learner,
  resampling,
  measures = NULL,
  terminator,
  search_space = NULL,
  store_benchmark_result = TRUE,
  store_models = FALSE,
  check_values = FALSE,
  allow_hotstart = FALSE,
  keep_hotstart_stack = FALSE,
  evaluate_default = FALSE
)
}
\arguments{
\item{task}{(\link[mlr3:Task]{mlr3::Task})\cr
Task to operate on.}

\item{learner}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Learner to tune.}

\item{resampling}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Resampling that is used to evaluated the performance of the hyperparameter
configurations. Uninstantiated resamplings are instantiated during
construction so that all configurations are evaluated on the same data
splits. Already instantiated resamplings are kept unchanged. Specialized
\link{Tuner} change the resampling e.g. to evaluate a hyperparameter
configuration on different data splits. This field, however, always returns
the resampling passed in construction.}

\item{measures}{(\link[mlr3:Measure]{mlr3::Measure} or list of \link[mlr3:Measure]{mlr3::Measure})\cr
A single measure creates a \link{TuningInstanceSingleCrit} and multiple measures a \link{TuningInstanceMultiCrit}.
If \code{NULL}, default measure is used.}

\item{terminator}{(\link{Terminator})\cr
Stop criterion of the tuning process.}

\item{search_space}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Hyperparameter search space. If \code{NULL} (default), the search space is
constructed from the \link{TuneToken} of the learner's parameter set
(learner$param_set).}

\item{store_benchmark_result}{(\code{logical(1)})\cr
If \code{TRUE} (default), store resample result of evaluated hyperparameter
configurations in archive as \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}.}

\item{store_models}{(\code{logical(1)})\cr
If \code{TRUE}, fitted models are stored in the benchmark result
(\code{archive$benchmark_result}). If \code{store_benchmark_result = FALSE}, models
are only stored temporarily and not accessible after the tuning. This
combination is needed for measures that require a model.}

\item{check_values}{(\code{logical(1)})\cr
If \code{TRUE}, hyperparameter values are checked before evaluation and
performance scores after. If \code{FALSE} (default), values are unchecked but
computational overhead is reduced.}

\item{allow_hotstart}{(\code{logical(1)})\cr
Allow to hotstart learners with previously fitted models. See also
\link[mlr3:HotstartStack]{mlr3::HotstartStack}. The learner must support hotstarting. Sets
\code{store_models = TRUE}.}

\item{keep_hotstart_stack}{(\code{logical(1)})\cr
If \code{TRUE}, \link[mlr3:HotstartStack]{mlr3::HotstartStack} is kept in \verb{$objective$hotstart_stack}
after tuning.}

\item{evaluate_default}{(\code{logical(1)})\cr
If \code{TRUE}, learner is evaluated with hyperparameters set to their default
values at the start of the optimization.}
}
\description{
Function to construct a \link{TuningInstanceSingleCrit} or \link{TuningInstanceMultiCrit}.
}
\section{Resources}{

\itemize{
\item \href{https://mlr3book.mlr-org.com/optimization.html#tuning}{book chapter} on hyperparameter optimization.
\item \href{https://mlr3book.mlr-org.com/optimization.html#searchspace}{book chapter} on tuning spaces.
\item \href{https://mlr-org.com/gallery/2021-03-09-practical-tuning-series-tune-a-support-vector-machine/practical-tuning-series-tune-a-support-vector-machine.html}{gallery post} on tuning.
\item \href{https://mlr3tuningspaces.mlr-org.com/}{mlr3tuningspaces} extension package.
}
}

\examples{
# get learner and define search space
learner = lrn("classif.rpart", cp = to_tune(1e-04, 1e-1, logscale = TRUE))

# construct tuning instance
instance = ti(
  task = tsk("pima"),
  learner = learner,
  resampling = rsmp ("holdout"),
  measures = msr("classif.ce"),
  terminator = trm("evals", n_evals = 4)
)

# get tuner
tuner = tnr("random_search", batch_size = 2)

# tune classification tree on pima data set
tuner$optimize(instance)

# get result
instance$result
}
