% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerRandomSearch.R
\docType{data}
\name{TunerRandomSearch}
\alias{TunerRandomSearch}
\alias{mlr_tuners_random_search}
\title{TunerRandomSearch}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Tuner}.}
\description{
Subclass for random search tuning.

The random points are sampled by \code{\link[paradox:generate_design_random]{paradox::generate_design_random()}}.

In order to support general termination criteria and parallelization,
we evaluate points in a batch-fashion of size \code{batch_size}.
Larger batches mean we can parallelize more, smaller batches imply a more fine-grained checking
of termination criteria.
}
\section{Construction}{
\preformatted{TunerRandomSearch$new(batch_size = 1L)
tnr("random_search")
}
}

\section{Parameters}{

\itemize{
\item \code{batch_size} :: \code{integer(1)}\cr
Maximum number of configurations to try in a batch.
}
}

\examples{
# see ?Tuner
}
\seealso{
Other Tuner: \code{\link{TunerDesignPoints}},
  \code{\link{TunerGenSA}}, \code{\link{TunerGridSearch}},
  \code{\link{Tuner}}, \code{\link{mlr_tuners}}
}
\concept{Tuner}
\keyword{datasets}
