% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_dataset.R
\name{task_dataset}
\alias{task_dataset}
\title{Create a Dataset from a Task}
\usage{
task_dataset(task, feature_ingress_tokens, target_batchgetter = NULL, device)
}
\arguments{
\item{task}{(\code{\link[mlr3:Task]{Task}})\cr
The task for which to build the \link[torch:dataset]{dataset}.}

\item{feature_ingress_tokens}{(named \code{list()} of \code{\link{TorchIngressToken}})\cr
Each ingress token defines one item in the \verb{$x} value of a batch with corresponding names.}

\item{target_batchgetter}{(\verb{function(data, device)})\cr
A function taking in arguments \code{data}, which is a \code{data.table} containing only the target variable, and \code{device}.
It must return the target as a torch \link[torch:torch_tensor]{tensor} on the selected device.}

\item{device}{(\code{character()})\cr
The device, e.g. \code{"cuda"} or \code{"cpu"}.}
}
\value{
\code{\link[torch:dataset]{torch::dataset}}
}
\description{
Creates a torch \link[torch:dataset]{dataset} from an mlr3 \code{\link[mlr3:Task]{Task}}.
The resulting dataset's \verb{$.get_batch()} method returns a list with elements \code{x}, \code{y} and \code{index}:
\itemize{
\item \code{x} is a list with tensors, whose content is defined by the parameter \code{feature_ingress_tokens}.
\item \code{y} is the target variable and its content is defined by the parameter \code{target_batchgetter}.
\item \code{.index} is the index of the batch in the task's data.
}

The data is returned on the device specified by the parameter \code{device}.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
task = tsk("iris")
sepal_ingress = TorchIngressToken(
  features = c("Sepal.Length", "Sepal.Width"),
  batchgetter = batchgetter_num,
  shape = c(NA, 2)
)
petal_ingress = TorchIngressToken(
  features = c("Petal.Length", "Petal.Width"),
  batchgetter = batchgetter_num,
  shape = c(NA, 2)
)
ingress_tokens = list(sepal = sepal_ingress, petal = petal_ingress)

target_batchgetter = function(data, device) {
  torch_tensor(data = data[[1L]], dtype = torch_float32(), device)$unsqueeze(2)
}
dataset = task_dataset(task, ingress_tokens, target_batchgetter, "cpu")
batch = dataset$.getbatch(1:10)
batch
\dontshow{\}) # examplesIf}
}
