% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTorchModel.R
\name{mlr_pipeops_torch_model_regr}
\alias{mlr_pipeops_torch_model_regr}
\alias{PipeOpTorchModelRegr}
\title{Torch Regression Model}
\description{
Builds a torch regression model and trains it.
}
\section{Parameters}{
 See \code{\link{LearnerTorch}}
}

\section{Input and Output Channels}{

There is one input channel \code{"input"} that takes in \code{ModelDescriptor} during traing and a \code{Task} of the specified
\code{task_type} during prediction.
The output is \code{NULL} during training and a \code{Prediction} of given \code{task_type} during prediction.
}

\section{State}{

A trained \code{\link{LearnerTorchModel}}.
}

\section{Internals}{

A \code{\link{LearnerTorchModel}} is created by calling \code{\link[=model_descriptor_to_learner]{model_descriptor_to_learner()}} on the
provided \code{\link{ModelDescriptor}} that is received through the input channel.
Then the parameters are set according to the parameters specified in \code{PipeOpTorchModel} and
its '$train()\verb{ method is called on the [}Task\verb{][mlr3::Task] stored in the [}ModelDescriptor`].
}

\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# simple linear regression

# build the model descriptor
md = as_graph(po("torch_ingress_num") \%>>\%
  po("nn_head") \%>>\%
  po("torch_loss", "mse") \%>>\%
  po("torch_optimizer", "adam"))$train(tsk("mtcars"))[[1L]]

print(md)

# build the learner from the model descriptor and train it
po_model = po("torch_model_regr", batch_size = 20, epochs = 1)
po_model$train(list(md))
po_model$state
\dontshow{\}) # examplesIf}
}
\seealso{
Other PipeOps: 
\code{\link{mlr_pipeops_nn_avg_pool1d}},
\code{\link{mlr_pipeops_nn_avg_pool2d}},
\code{\link{mlr_pipeops_nn_avg_pool3d}},
\code{\link{mlr_pipeops_nn_batch_norm1d}},
\code{\link{mlr_pipeops_nn_batch_norm2d}},
\code{\link{mlr_pipeops_nn_batch_norm3d}},
\code{\link{mlr_pipeops_nn_block}},
\code{\link{mlr_pipeops_nn_celu}},
\code{\link{mlr_pipeops_nn_conv1d}},
\code{\link{mlr_pipeops_nn_conv2d}},
\code{\link{mlr_pipeops_nn_conv3d}},
\code{\link{mlr_pipeops_nn_conv_transpose1d}},
\code{\link{mlr_pipeops_nn_conv_transpose2d}},
\code{\link{mlr_pipeops_nn_conv_transpose3d}},
\code{\link{mlr_pipeops_nn_dropout}},
\code{\link{mlr_pipeops_nn_elu}},
\code{\link{mlr_pipeops_nn_flatten}},
\code{\link{mlr_pipeops_nn_gelu}},
\code{\link{mlr_pipeops_nn_glu}},
\code{\link{mlr_pipeops_nn_hardshrink}},
\code{\link{mlr_pipeops_nn_hardsigmoid}},
\code{\link{mlr_pipeops_nn_hardtanh}},
\code{\link{mlr_pipeops_nn_head}},
\code{\link{mlr_pipeops_nn_layer_norm}},
\code{\link{mlr_pipeops_nn_leaky_relu}},
\code{\link{mlr_pipeops_nn_linear}},
\code{\link{mlr_pipeops_nn_log_sigmoid}},
\code{\link{mlr_pipeops_nn_max_pool1d}},
\code{\link{mlr_pipeops_nn_max_pool2d}},
\code{\link{mlr_pipeops_nn_max_pool3d}},
\code{\link{mlr_pipeops_nn_merge}},
\code{\link{mlr_pipeops_nn_merge_cat}},
\code{\link{mlr_pipeops_nn_merge_prod}},
\code{\link{mlr_pipeops_nn_merge_sum}},
\code{\link{mlr_pipeops_nn_prelu}},
\code{\link{mlr_pipeops_nn_relu}},
\code{\link{mlr_pipeops_nn_relu6}},
\code{\link{mlr_pipeops_nn_reshape}},
\code{\link{mlr_pipeops_nn_rrelu}},
\code{\link{mlr_pipeops_nn_selu}},
\code{\link{mlr_pipeops_nn_sigmoid}},
\code{\link{mlr_pipeops_nn_softmax}},
\code{\link{mlr_pipeops_nn_softplus}},
\code{\link{mlr_pipeops_nn_softshrink}},
\code{\link{mlr_pipeops_nn_softsign}},
\code{\link{mlr_pipeops_nn_squeeze}},
\code{\link{mlr_pipeops_nn_tanh}},
\code{\link{mlr_pipeops_nn_tanhshrink}},
\code{\link{mlr_pipeops_nn_threshold}},
\code{\link{mlr_pipeops_nn_unsqueeze}},
\code{\link{mlr_pipeops_torch_ingress}},
\code{\link{mlr_pipeops_torch_ingress_categ}},
\code{\link{mlr_pipeops_torch_ingress_ltnsr}},
\code{\link{mlr_pipeops_torch_ingress_num}},
\code{\link{mlr_pipeops_torch_loss}},
\code{\link{mlr_pipeops_torch_model}},
\code{\link{mlr_pipeops_torch_model_classif}}
}
\concept{PipeOps}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpLearner]{mlr3pipelines::PipeOpLearner}} -> \code{\link[mlr3torch:PipeOpTorchModel]{mlr3torch::PipeOpTorchModel}} -> \code{PipeOpTorchModelRegr}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpTorchModelRegr-new}{\code{PipeOpTorchModelRegr$new()}}
\item \href{#method-PipeOpTorchModelRegr-clone}{\code{PipeOpTorchModelRegr$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTorchModelRegr-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTorchModelRegr-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTorchModelRegr$new(id = "torch_model_regr", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTorchModelRegr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTorchModelRegr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTorchModelRegr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
