% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingRepeatedSptCVCstf.R
\name{ResamplingRepeatedSptCVCstf}
\alias{ResamplingRepeatedSptCVCstf}
\title{Repeated "Leave-location-and-time-out" resampling.}
\description{
Implementation of \code{CAST::CreateSpaceTimeFolds()}.
}
\details{
Using "class" is helpful in the case that data are clustered in space
and are categorical. E.g This is the case for land cover classifications when
training data come as training polygons. In this case the data should be split in a way
that entire polygons are held back (spacevar="polygonID") but at the same time the distribution of classes
should be similar in each fold (class="LUC").
}
\examples{
library(mlr3)
library(mlr3spatiotempcv)
task = tsk("cookfarm")

# Instantiate Resampling
rrcv = rsmp("repeated_sptcv_cstf", folds = 3, repeats = 5, time_var = "Date")
rrcv$instantiate(task)
# Individual sets:
rrcv$iters
rrcv$folds(1:6)
rrcv$repeats(1:6)

# Individual sets:
rrcv$train_set(1)
rrcv$test_set(1)
intersect(rrcv$train_set(1), rrcv$test_set(1))

# Internal storage:
rrcv$instance # table
}
\references{
Zhao Y, Karypis G (2002).
\dQuote{Evaluation of Hierarchical Clustering Algorithms for Document Datasets.}
\emph{11th Conference of Information and Knowledge Management (CIKM)}, 51-524.
\url{http://glaros.dtc.umn.edu/gkhome/node/167}.
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingRepeatedSptCVCstf}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{space_var}}{\code{character(1)}\cr
Column name identifying the spatial units.}

\item{\code{time_var}}{\code{character(1)}\cr
Column name identifying the temporal units.}

\item{\code{class}}{\code{character(1)}\cr
Column name identifying a class unit (e.g. land cover).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Returns the number of resampling iterations, depending on the
values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ResamplingRepeatedSptCVCstf$new()}}
\item \href{#method-folds}{\code{ResamplingRepeatedSptCVCstf$folds()}}
\item \href{#method-repeats}{\code{ResamplingRepeatedSptCVCstf$repeats()}}
\item \href{#method-instantiate}{\code{ResamplingRepeatedSptCVCstf$instantiate()}}
\item \href{#method-clone}{\code{ResamplingRepeatedSptCVCstf$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format">}\href{../../mlr3/html/Resampling.html#method-format}{\code{mlr3::Resampling$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help">}\href{../../mlr3/html/Resampling.html#method-help}{\code{mlr3::Resampling$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print">}\href{../../mlr3/html/Resampling.html#method-print}{\code{mlr3::Resampling$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set">}\href{../../mlr3/html/Resampling.html#method-test_set}{\code{mlr3::Resampling$test_set()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set">}\href{../../mlr3/html/Resampling.html#method-train_set}{\code{mlr3::Resampling$train_set()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a "Spacetime Folds" resampling instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$new(
  id = "repeated_sptcv_cstf",
  space_var = NULL,
  time_var = NULL,
  class = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)}\cr
Identifier for the resampling strategy.}

\item{\code{space_var}}{\code{character(1)}\cr
Column name identifying the spatial units.}

\item{\code{time_var}}{\code{character(1)}\cr
Column name identifying the temporal units.}

\item{\code{class}}{\code{character(1)}\cr
Column name identifying a class unit (e.g. land cover).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-folds"></a>}}
\if{latex}{\out{\hypertarget{method-folds}{}}}
\subsection{Method \code{folds()}}{
Translates iteration numbers to fold number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$folds(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-repeats"></a>}}
\if{latex}{\out{\hypertarget{method-repeats}{}}}
\subsection{Method \code{repeats()}}{
Translates iteration numbers to repetition number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$repeats(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-instantiate"></a>}}
\if{latex}{\out{\hypertarget{method-instantiate}{}}}
\subsection{Method \code{instantiate()}}{
Materializes fixed training and test splits for a given task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$instantiate(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\link{Task}\cr
A task to instantiate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
