% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_spcv_cstf.R
\name{autoplot.ResamplingSptCVCstf}
\alias{autoplot.ResamplingSptCVCstf}
\alias{autoplot.ResamplingRepeatedSptCVCstf}
\alias{plot.ResamplingSptCVCstf}
\alias{plot.ResamplingRepeatedSptCVCstf}
\title{Visualization Functions for SptCV Cstf Methods.}
\usage{
\method{autoplot}{ResamplingSptCVCstf}(
  object,
  task,
  fold_id = NULL,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  tickformat_date = "\%Y-\%m",
  crs = NULL,
  nticks_x = 3,
  nticks_y = 3,
  point_size = 3,
  axis_label_fontsize = 11,
  ...
)

\method{autoplot}{ResamplingRepeatedSptCVCstf}(
  object,
  task,
  fold_id = NULL,
  repeats_id = NULL,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  tickformat_date = "\%Y-\%m",
  crs = NULL,
  nticks_x = 3,
  nticks_y = 3,
  point_size = 3,
  axis_label_fontsize = 11,
  ...
)

\method{plot}{ResamplingSptCVCstf}(x, ...)

\method{plot}{ResamplingRepeatedSptCVCstf}(x, ...)
}
\arguments{
\item{object}{\verb{[Resampling]}\cr
mlr3 spatial resampling object of class \link{ResamplingSptCVCstf} or
\link{ResamplingRepeatedSptCVCstf}.}

\item{task}{\verb{[TaskClassifST]/[TaskRegrST]}\cr
mlr3 task object.}

\item{fold_id}{\verb{[numeric]}\cr
Fold IDs to plot.}

\item{plot_as_grid}{\verb{[logical(1)]}\cr
Should a gridded plot using via \CRANpkg{patchwork} be created? If \code{FALSE}
only a list with all \CRANpkg{ggplot2} resamplings is returned. Only applies
if a numeric vector is passed to argument \code{fold_id}.}

\item{train_color}{\verb{[character(1)]}\cr
The color to use for the training set observations.}

\item{test_color}{\verb{[character(1)]}\cr
The color to use for the test set observations.}

\item{tickformat_date}{\verb{[character]}\cr
Date format for z-axis.}

\item{crs}{\verb{[character]}\cr
EPSG code of the CRS for x and y axes.
If not set, EPSG 4326 (WGS84) is used.}

\item{nticks_x}{\verb{[integer]}\cr
Number of x axis breaks.}

\item{nticks_y}{\verb{[integer]}\cr
Number of y axis breaks.}

\item{point_size}{\verb{[numeric]}\cr
Point size of markers.}

\item{axis_label_fontsize}{\verb{[integer]}\cr
Font size of axis labels.}

\item{...}{Not used.}

\item{repeats_id}{\verb{[numeric]}\cr
Repetition ID to plot.}

\item{x}{\verb{[Resampling]}\cr
mlr3 spatial resampling object of class \link{ResamplingSptCVCstf} or
\link{ResamplingRepeatedSptCVCstf}.}
}
\description{
Generic S3 \code{plot()} and \code{autoplot()} (ggplot2) methods.
}
\examples{
\donttest{
library(mlr3)
library(mlr3spatiotempcv)
task_st = tsk("cookfarm")
resampling = rsmp("sptcv_cstf", folds = 5, time_var = "Date")
resampling$instantiate(task_st)

# plot
autoplot(resampling, task_st)
autoplot(resampling, task_st, 1)
autoplot(resampling, task_st, c(1, 2))
}
}
