% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpCrankCompositor.R
\name{PipeOpCrankCompositor}
\alias{PipeOpCrankCompositor}
\alias{mlr_pipeops_crankcompose}
\title{PipeOpCrankCompositor}
\description{
Uses a predicted \code{distr} in a \link{PredictionSurv} to estimate (or 'compose') a \code{crank} prediction.
}
\section{Dictionary}{

This \link[mlr3pipelines:PipeOp]{PipeOp} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3pipelines:mlr_pipeops]{mlr3pipelines::mlr_pipeops} or with the associated sugar function \code{\link[mlr3pipelines:po]{mlr3pipelines::po()}}:\preformatted{PipeOpCrankCompositor$new()
mlr_pipeops$get("crankcompose")
po("crankcompose")
}
}

\section{Input and Output Channels}{

\link{PipeOpCrankCompositor} has one input channel named "input", which takes
\code{NULL} during training and \link{PredictionSurv} during prediction.

\link{PipeOpCrankCompositor} has one output channel named "output", producing \code{NULL} during training
and a \link{PredictionSurv} during prediction.

The output during prediction is the \link{PredictionSurv} from the "pred" input but with the \code{crank}
predict type overwritten by the given estimation method.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

\itemize{
\item \code{method} :: \code{character(1)} \cr
Determines what method should be used to produce a continuous ranking from the distribution.
One of \code{median}, \code{mode}, or \code{mean} corresponding to the respective functions in the predicted
survival distribution. Note that for models with a proportional hazards form, the ranking
implied by \code{mean} and \code{median} will be identical (but not the value of \code{crank} itself).
Default is \code{mean}.
}
}

\section{Internals}{

The \code{median}, \code{mode}, or \code{mean} will use analytical expressions if possible but if not they are calculated
using \link[distr6:median.Distribution]{distr6::median.Distribution}, \link[distr6:mode]{distr6::mode}, or \link[distr6:mean.Distribution]{distr6::mean.Distribution} respectively.
}

\section{Fields}{

Only fields inherited from \link[mlr3pipelines:PipeOp]{PipeOp}.
}

\section{Methods}{

Only fields inherited from \link[mlr3pipelines:PipeOp]{PipeOp}.
}

\examples{
library(mlr3)
library(mlr3pipelines)
set.seed(1)

# Three methods to predict a `crank` from `surv.rpart`
task = tgen("simsurv")$generate(30)

# Method 1 - Train and predict separately then compose
learn = lrn("surv.coxph")$train(task)$predict(task)
poc = po("crankcompose", param_vals = list(method = "mean"))
poc$predict(list(learn))

# Examples not run to save run-time.
\dontrun{
# Method 2 - Create a graph manually
gr = Graph$new()$
  add_pipeop(po("learner", lrn("surv.ranger")))$
  add_pipeop(po("crankcompose"))$
  add_edge("surv.ranger", "crankcompose")
gr$train(task)
gr$predict(task)

# Method 3 - Syntactic sugar: Wrap the learner in a graph
ranger.crank = crankcompositor(learner = lrn("surv.ranger"),
                            method = "median")
resample(task, ranger.crank, rsmp("cv", folds = 2))$predictions()
}
}
\seealso{
\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp} and \link{crankcompositor}

Other survival compositors: 
\code{\link{PipeOpDistrCompositor}}
}
\concept{survival compositors}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpCrankCompositor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpCrankCompositor$new()}}
\item \href{#method-train_internal}{\code{PipeOpCrankCompositor$train_internal()}}
\item \href{#method-predict_internal}{\code{PipeOpCrankCompositor$predict_internal()}}
\item \href{#method-clone}{\code{PipeOpCrankCompositor$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpCrankCompositor$new(
  id = "crankcompose",
  param_vals = list(method = "mean")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-train_internal"></a>}}
\subsection{Method \code{train_internal()}}{
train_internal
Internal \code{train} function, will be moved to \code{private} in a near-future update, should be ignored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpCrankCompositor$train_internal(inputs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inputs}}{Ignore.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict_internal"></a>}}
\subsection{Method \code{predict_internal()}}{
predict_internal
Internal \code{predict} function, will be moved to \code{private} in a near-future update, should be ignored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpCrankCompositor$predict_internal(inputs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inputs}}{Ignore.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpCrankCompositor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
