% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvGBM.R
\name{LearnerSurvGBM}
\alias{LearnerSurvGBM}
\alias{mlr_learners_surv.gbm}
\title{Generalized Boosting Regression Modeling Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[gbm:gbm]{gbm::gbm()}}.
\itemize{
\item lp is predicted by \code{\link[gbm:predict.gbm]{gbm::predict.gbm()}}
\item \code{crank} is identical to \code{lp}
}

Parameter \code{distribution} is set to \code{coxph} as this is the only distribution implemented
in \code{\link[gbm:gbm]{gbm::gbm()}} for survival analysis; parameter \code{keep.data} is set to \code{FALSE} for efficiency.
}
\section{Construction}{
\preformatted{LearnerSurvGBM$new()
mlr_learners$get("surv.gbm")
lrn("surv.gbm")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{crank, lp}
\item Feature Types: \verb{integer, numeric, factor, ordered}
\item Packages: \CRANpkg{gbm}
}
}

\references{
\cite{mlr3proba}{freund_1997}

\cite{mlr3proba}{ridgeway_1999}

\cite{mlr3proba}{friedman_2000}

\cite{mlr3proba}{friedman_2001}

\cite{mlr3proba}{friedman_2001}

\cite{mlr3proba}{friedman_2002}

\cite{mlr3proba}{kriegler_2007}

\cite{mlr3proba}{burges_2010}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvObliqueRSF}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
