% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_pipeops.R
\docType{data}
\name{mlr_pipeops}
\alias{mlr_pipeops}
\title{Dictionary of PipeOps}
\format{
\code{\link{R6Class}} object inheriting from \code{\link[mlr3misc:Dictionary]{mlr3misc::Dictionary}}.
}
\description{
A simple \code{\link[mlr3misc:Dictionary]{Dictionary}} storing objects of class \code{\link{PipeOp}}.
Each \code{PipeOp} has an associated help page, see \code{mlr_pipeops_[id]}.
}
\section{Fields}{

Fields inherited from \code{\link[mlr3misc:Dictionary]{Dictionary}}, as well as:
\itemize{
\item \code{metainf} :: \code{environment}\cr
Environment that stores the \code{metainf} argument of the \verb{$add()} method.
Only for internal use.
}
}

\section{Methods}{

Methods inherited from \code{\link[mlr3misc:Dictionary]{Dictionary}}, as well as:
\itemize{
\item \code{add(key, value, metainf = NULL)}\cr
(\code{character(1)}, \code{R6ClassGenerator}, \code{NULL} | \code{list})\cr
Adds constructor \code{value} to the dictionary with key \code{key}, potentially
overwriting a previously stored item. If \code{metainf} is not \code{NULL} (the default),
it must be a \code{list} of arguments that will be given to the \code{value} constructor (i.e. \code{value$new()})
when it needs to be constructed for \code{as.data.table} \code{\link{PipeOp}} listing.
}
}

\section{S3 methods}{

\itemize{
\item \code{as.data.table(dict)}\cr
\code{\link[mlr3misc:Dictionary]{Dictionary}} -> \code{\link[data.table:data.table]{data.table::data.table}}\cr
Returns a \code{data.table} with columns \code{key} (\code{character}), \code{packages} (\code{character}),
\code{input.num} (\code{integer}), \code{output.num} (\code{integer}), \code{input.type.train} (\code{character}),
\code{input.type.predict} (\code{character}), \code{output.type.train} (\code{character}), \code{output.type.predict} (\code{character}).
}
}

\examples{
library("mlr3")

mlr_pipeops$get("learner", lrn("classif.rpart"))

# equivalent:
po("learner", learner = lrn("classif.rpart"))

# all PipeOps currently in the dictionary:
as.data.table(mlr_pipeops)[, c("key", "input.num", "output.num", "packages")]
}
\seealso{
Other mlr3pipelines backend related: 
\code{\link{Graph}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOp}},
\code{\link{mlr_graphs}},
\code{\link{mlr_pipeops_updatetarget}}

Other PipeOps: 
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpProxy}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOp}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_yeojohnson}}

Other Dictionaries: 
\code{\link{mlr_graphs}}
}
\concept{Dictionaries}
\concept{PipeOps}
\concept{mlr3pipelines backend related}
\keyword{datasets}
